/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ext.DataProviderException;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public final class PropertyFileServerDataProvider
implements ServerDataProvider {
    private static String SERVERFILE_SUFFIX = ".jcoServer";
    private File parentDirectory = null;

    PropertyFileServerDataProvider(String directory) throws FileNotFoundException {
        File dir = new File(directory);
        if (!dir.exists()) {
            String path = dir.getAbsolutePath();
            throw new FileNotFoundException(new StringBuilder(path.length() + 27).append("Directory \"").append(path).append("\" does not exist").toString());
        }
        if (!dir.canRead()) {
            String path = dir.getAbsolutePath();
            throw new FileNotFoundException(new StringBuilder(path.length() + 34).append("Read access to directory \"").append(path).append("\" denied").toString());
        }
        this.parentDirectory = dir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getServerProperties(String serverName) {
        Properties properties;
        File propertiesFile;
        if (serverName == null) {
            serverName = "";
        }
        if (!(propertiesFile = new File(this.parentDirectory, new StringBuilder(serverName.length() + SERVERFILE_SUFFIX.length()).append(serverName).append(SERVERFILE_SUFFIX).toString())).exists()) {
            return null;
        }
        if (!propertiesFile.canRead()) {
            String path = propertiesFile.getAbsolutePath();
            throw new DataProviderException(DataProviderException.Reason.IO_ERROR, new StringBuilder(path.length() + 29).append("Read access to file \"").append(path).append("\" denied").toString(), null);
        }
        BufferedInputStream in = null;
        try {
            try {
                in = new BufferedInputStream(new FileInputStream(propertiesFile));
                Properties properties2 = new Properties();
                properties2.load(in);
                properties = properties2;
                Object var7_9 = null;
                if (in == null) return properties;
            }
            catch (IOException exc) {
                String path = propertiesFile.getAbsolutePath();
                throw new DataProviderException(DataProviderException.Reason.IO_ERROR, new StringBuilder(path.length() + 22).append("Failed to read file \"").append(path).append('\"').toString(), exc);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception exc2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exc2) {
            // empty catch block
            return properties;
        }
        in.close();
        return properties;
    }

    public boolean supportsEvents() {
        return false;
    }

    public void setServerDataEventListener(ServerDataEventListener eventListener) {
    }
}

