/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.naming;

import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import com.github.victools.jsonschema.generator.naming.SchemaDefinitionNamingStrategy;
import java.util.Map;
import java.util.function.Function;

public class CleanSchemaDefinitionNamingStrategy
implements SchemaDefinitionNamingStrategy {
    private final SchemaDefinitionNamingStrategy strategy;
    private final Function<String, String> cleanUpTask;

    public CleanSchemaDefinitionNamingStrategy(SchemaDefinitionNamingStrategy strategy, Function<String, String> cleanUpTask) {
        this.strategy = strategy;
        this.cleanUpTask = cleanUpTask;
    }

    @Override
    public String getDefinitionNameForKey(DefinitionKey key, SchemaGenerationContext generationContext) {
        String output = this.strategy.getDefinitionNameForKey(key, generationContext);
        return this.cleanUpTask.apply(output);
    }

    @Override
    public void adjustDuplicateNames(Map<DefinitionKey, String> subschemasWithDuplicateNames, SchemaGenerationContext generationContext) {
        this.strategy.adjustDuplicateNames(subschemasWithDuplicateNames, generationContext);
        subschemasWithDuplicateNames.entrySet().forEach(entry -> entry.setValue(this.cleanUpTask.apply((String)entry.getValue())));
    }

    @Override
    public String adjustNullableName(DefinitionKey key, String definitionName, SchemaGenerationContext generationContext) {
        String output = this.strategy.adjustNullableName(key, definitionName, generationContext);
        return this.cleanUpTask.apply(output);
    }
}

