/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import java.util.function.Predicate;

public class FieldExclusionModule
implements Module {
    private final Predicate<FieldScope> shouldExcludeFieldsMatching;

    public static FieldExclusionModule forPublicNonStaticFields() {
        return new FieldExclusionModule(field -> field.isPublic() && !field.isStatic());
    }

    public static FieldExclusionModule forNonPublicNonStaticFieldsWithGetter() {
        return new FieldExclusionModule(field -> !field.isPublic() && !field.isStatic() && field.hasGetter());
    }

    public static FieldExclusionModule forNonPublicNonStaticFieldsWithoutGetter() {
        return new FieldExclusionModule(field -> !field.isPublic() && !field.isStatic() && !field.hasGetter());
    }

    public static FieldExclusionModule forTransientFields() {
        return new FieldExclusionModule(FieldScope::isTransient);
    }

    public FieldExclusionModule(Predicate<FieldScope> shouldExcludeFieldsMatching) {
        this.shouldExcludeFieldsMatching = shouldExcludeFieldsMatching;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withIgnoreCheck(this.shouldExcludeFieldsMatching);
    }
}

