/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.codegen.yaml;

import com.google.common.collect.ImmutableMap;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.codegen.yaml.binding.ConfigModel;
import org.apache.maven.plugin.codegen.yaml.binding.ConfigModelOutput;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="generate", requiresProject=false, threadSafe=true)
public class YamlCodeGenMojo
extends AbstractMojo {
    public static final String DEFAULT_GOAL = "generate";
    public static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    public static final Version DEFAULT_FREEMARKER_VERSION = Configuration.VERSION_2_3_29;
    @Parameter(name="models", required=true)
    private List<ConfigModel> models = new ArrayList<ConfigModel>();

    public void execute() throws MojoExecutionException {
        StopWatch started = StopWatch.createStarted();
        this.getLog().info((CharSequence)("Found " + this.models.size() + " configured model(s)."));
        this.validatedDeclaredModel();
        try {
            for (ConfigModel configModel : this.models) {
                File modelFile = configModel.getFile();
                Map<String, Object> modelContent = this.loadModel(modelFile);
                for (ConfigModelOutput output : configModel.getOutputs()) {
                    this.getLog().debug((CharSequence)("Preparing FreeMarker to render " + modelFile));
                    File templateFile = output.getTmpl();
                    Configuration cfg = new Configuration(DEFAULT_FREEMARKER_VERSION);
                    cfg.setDefaultEncoding(DEFAULT_ENCODING.displayName());
                    cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                    cfg.setLogTemplateExceptions(false);
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(templateFile.getParentFile()));
                    Template template = cfg.getTemplate(templateFile.getName());
                    File outputDst = output.getDst();
                    Writer writer = this.prepareDestinationForWrite(outputDst);
                    Throwable throwable = null;
                    try {
                        HashMap<String, ImmutableMap> root = new HashMap<String, ImmutableMap>();
                        root.put("model", ImmutableMap.of((Object)"content", modelContent, (Object)"file", (Object)modelFile));
                        root.put("output", ImmutableMap.of((Object)"file", (Object)new File(outputDst.getPath())));
                        root.put("tmpl", ImmutableMap.of((Object)"file", (Object)templateFile, (Object)"vars", (Object)ObjectUtils.defaultIfNull(output.getTmplVars(), Collections.emptyMap())));
                        template.process(root, writer);
                        writer.flush();
                        this.getLog().info((CharSequence)("Processed  " + modelFile + " to " + outputDst));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
            }
            started.stop();
            this.getLog().info((CharSequence)(this.models.size() + " model(s) processed in " + started.getTime(TimeUnit.MILLISECONDS) + " in ms."));
        }
        catch (TemplateException | IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void validatedDeclaredModel() throws MojoExecutionException {
        if (this.models.isEmpty()) {
            throw new MojoExecutionException("No models configured. Please, either add one or remove plugin declaration.");
        }
    }

    private Map<String, Object> loadModel(File modelFile) throws IOException {
        this.getLog().debug((CharSequence)("Loading model from " + modelFile));
        try (FileInputStream io = new FileInputStream(modelFile);){
            Map map = (Map)new Yaml().load((InputStream)io);
            return map;
        }
    }

    private Writer prepareDestinationForWrite(File outputDst) throws IOException {
        File outDstParent = outputDst.getParentFile();
        if (!outDstParent.exists()) {
            outDstParent.mkdirs();
        }
        return new FileWriter(outputDst);
    }
}

