/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import org.apache.commons.lang3.StringUtils;

class DiffLine<V> {
    protected final String requestAttribute;
    protected final NamedValueMatcher<V> pattern;
    protected final V value;
    protected final String printedPatternValue;

    public DiffLine(String requestAttribute, NamedValueMatcher<V> pattern, V value, String printedPatternValue) {
        this.requestAttribute = requestAttribute;
        this.pattern = pattern;
        this.value = value;
        this.printedPatternValue = printedPatternValue;
    }

    public String getRequestAttribute() {
        return this.requestAttribute;
    }

    public Object getActual() {
        return this.value;
    }

    public String getPrintedPatternValue() {
        return this.printedPatternValue;
    }

    public boolean isForNonMatch() {
        return !this.isExactMatch();
    }

    protected boolean isExactMatch() {
        return this.pattern.match(this.value).isExactMatch();
    }

    public String getMessage() {
        String message = null;
        if (this.value == null || StringUtils.isEmpty((CharSequence)this.value.toString())) {
            message = this.requestAttribute + " is not present";
        } else {
            String string = message = this.isExactMatch() ? null : this.requestAttribute + " does not match";
        }
        if (this.isUrlRegexPattern() && !DiffLine.anyQuestionsMarksAreEscaped(this.pattern.getExpected())) {
            message = message + ". When using a regex, \"?\" should be \"\\\\?\"";
        }
        if (this.pattern instanceof UrlPattern && this.pattern != UrlPattern.ANY && !this.pattern.getExpected().startsWith("/")) {
            message = message + ". URLs must start with a /";
        }
        return message;
    }

    private static boolean anyQuestionsMarksAreEscaped(String s) {
        int index = s.indexOf(63);
        if (index == -1) {
            return true;
        }
        String sub = s.substring(index - 2, index);
        return sub.equals("\\\\");
    }

    private boolean isUrlRegexPattern() {
        return this.pattern instanceof UrlPattern && ((UrlPattern)this.pattern).isRegex();
    }
}

