/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class RequestPatternBuilder {
    private UrlPattern url;
    private RequestMethod method;
    private Map<String, MultiValuePattern> headers = Maps.newLinkedHashMap();
    private Map<String, MultiValuePattern> queryParams = Maps.newLinkedHashMap();
    private List<ContentPattern<?>> bodyPatterns = Lists.newArrayList();
    private Map<String, StringValuePattern> cookies = Maps.newLinkedHashMap();
    private BasicCredentials basicCredentials;
    private ValueMatcher<Request> customMatcher;
    private CustomMatcherDefinition customMatcherDefinition;

    public RequestPatternBuilder() {
    }

    public RequestPatternBuilder(ValueMatcher<Request> customMatcher) {
        this.customMatcher = customMatcher;
    }

    public RequestPatternBuilder(RequestMethod method, UrlPattern url) {
        this.method = method;
        this.url = url;
    }

    public RequestPatternBuilder(String customRequestMatcherName, Parameters parameters) {
        this.customMatcherDefinition = new CustomMatcherDefinition(customRequestMatcherName, parameters);
    }

    public static RequestPatternBuilder newRequestPattern(RequestMethod method, UrlPattern url) {
        return new RequestPatternBuilder(method, url);
    }

    public static RequestPatternBuilder newRequestPattern() {
        return new RequestPatternBuilder();
    }

    public static RequestPatternBuilder forCustomMatcher(ValueMatcher<Request> requestMatcher) {
        return new RequestPatternBuilder(requestMatcher);
    }

    public static RequestPatternBuilder forCustomMatcher(String customRequestMatcherName, Parameters parameters) {
        return new RequestPatternBuilder(customRequestMatcherName, parameters);
    }

    public static RequestPatternBuilder allRequests() {
        return new RequestPatternBuilder(RequestMethod.ANY, WireMock.anyUrl());
    }

    public static RequestPatternBuilder like(RequestPattern requestPattern) {
        RequestPatternBuilder builder = new RequestPatternBuilder();
        builder.url = requestPattern.getUrlMatcher();
        builder.method = requestPattern.getMethod();
        if (requestPattern.getHeaders() != null) {
            builder.headers = requestPattern.getHeaders();
        }
        if (requestPattern.getQueryParameters() != null) {
            builder.queryParams = requestPattern.getQueryParameters();
        }
        if (requestPattern.getCookies() != null) {
            builder.cookies = requestPattern.getCookies();
        }
        if (requestPattern.getBodyPatterns() != null) {
            builder.bodyPatterns = requestPattern.getBodyPatterns();
        }
        if (requestPattern.hasCustomMatcher()) {
            builder.customMatcher = requestPattern.getMatcher();
        }
        builder.basicCredentials = requestPattern.getBasicAuthCredentials();
        builder.customMatcherDefinition = requestPattern.getCustomMatcher();
        return builder;
    }

    public RequestPatternBuilder but() {
        return this;
    }

    public RequestPatternBuilder withUrl(String url) {
        this.url = WireMock.urlEqualTo(url);
        return this;
    }

    public RequestPatternBuilder withHeader(String key, StringValuePattern valuePattern) {
        this.headers.put(key, MultiValuePattern.of(valuePattern));
        return this;
    }

    public RequestPatternBuilder withoutHeader(String key) {
        this.headers.put(key, MultiValuePattern.absent());
        return this;
    }

    public RequestPatternBuilder withQueryParam(String key, StringValuePattern valuePattern) {
        this.queryParams.put(key, MultiValuePattern.of(valuePattern));
        return this;
    }

    public RequestPatternBuilder withCookie(String key, StringValuePattern valuePattern) {
        this.cookies.put(key, valuePattern);
        return this;
    }

    public RequestPatternBuilder withBasicAuth(BasicCredentials basicCredentials) {
        this.basicCredentials = basicCredentials;
        return this;
    }

    public RequestPatternBuilder withRequestBody(ContentPattern valuePattern) {
        this.bodyPatterns.add(valuePattern);
        return this;
    }

    public RequestPattern build() {
        return this.customMatcher != null ? new RequestPattern(this.customMatcher) : (this.customMatcherDefinition != null ? new RequestPattern(this.customMatcherDefinition) : new RequestPattern(this.url, this.method, this.headers.isEmpty() ? null : this.headers, this.queryParams.isEmpty() ? null : this.queryParams, this.cookies.isEmpty() ? null : this.cookies, this.basicCredentials, this.bodyPatterns.isEmpty() ? null : this.bodyPatterns, null));
    }
}

