/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import wiremock.org.custommonkey.xmlunit.ComparisonController;
import wiremock.org.custommonkey.xmlunit.Difference;
import wiremock.org.custommonkey.xmlunit.DifferenceEngine;
import wiremock.org.custommonkey.xmlunit.DifferenceEngineContract;
import wiremock.org.custommonkey.xmlunit.DifferenceListener;
import wiremock.org.custommonkey.xmlunit.ElementNameQualifier;
import wiremock.org.custommonkey.xmlunit.ElementQualifier;
import wiremock.org.custommonkey.xmlunit.MatchTracker;
import wiremock.org.custommonkey.xmlunit.NewDifferenceEngine;
import wiremock.org.custommonkey.xmlunit.Transform;
import wiremock.org.custommonkey.xmlunit.XMLUnit;
import wiremock.org.custommonkey.xmlunit.exceptions.XMLUnitRuntimeException;

public class Diff
implements DifferenceListener,
ComparisonController {
    private final Document controlDoc;
    private final Document testDoc;
    private boolean similar = true;
    private boolean identical = true;
    private boolean compared = false;
    private boolean haltComparison = false;
    private StringBuilder messages;
    private DifferenceEngineContract differenceEngine;
    private DifferenceListener differenceListenerDelegate;
    private ElementQualifier elementQualifierDelegate;
    private MatchTracker matchTrackerDelegate;

    public Diff(String control, String test) throws SAXException, IOException {
        this(new StringReader(control), new StringReader(test));
    }

    public Diff(Reader control, Reader test) throws SAXException, IOException {
        this(XMLUnit.buildDocument(XMLUnit.newControlParser(), control), XMLUnit.buildDocument(XMLUnit.newTestParser(), test));
    }

    public Diff(Document controlDoc, Document testDoc) {
        this(controlDoc, testDoc, null);
    }

    public Diff(String control, Transform testTransform) throws IOException, TransformerException, SAXException {
        this(XMLUnit.buildControlDocument(control), testTransform.getResultDocument());
    }

    public Diff(InputSource control, InputSource test) throws SAXException, IOException {
        this(XMLUnit.buildDocument(XMLUnit.newControlParser(), control), XMLUnit.buildDocument(XMLUnit.newTestParser(), test));
    }

    public Diff(DOMSource control, DOMSource test) {
        this(Diff.toDocument(control), Diff.toDocument(test));
    }

    public Diff(Document controlDoc, Document testDoc, DifferenceEngineContract comparator) {
        this(controlDoc, testDoc, comparator, new ElementNameQualifier());
    }

    public Diff(Document controlDoc, Document testDoc, DifferenceEngineContract comparator, ElementQualifier elementQualifier) {
        this.controlDoc = this.getManipulatedDocument(controlDoc);
        this.testDoc = this.getManipulatedDocument(testDoc);
        this.elementQualifierDelegate = elementQualifier;
        this.differenceEngine = comparator;
        this.messages = new StringBuilder();
    }

    protected Diff(Diff prototype) {
        this(prototype.controlDoc, prototype.testDoc, prototype.differenceEngine, prototype.elementQualifierDelegate);
        this.differenceListenerDelegate = prototype.differenceListenerDelegate;
    }

    private Document getWhitespaceManipulatedDocument(Document originalDoc) {
        return XMLUnit.getIgnoreWhitespace() ? XMLUnit.getWhitespaceStrippedDocument(originalDoc) : originalDoc;
    }

    private Document getManipulatedDocument(Document orig) {
        return this.getNormalizedDocument(this.getCommentlessDocument(this.getWhitespaceManipulatedDocument(orig)));
    }

    private Document getCommentlessDocument(Document orig) {
        if (!XMLUnit.getIgnoreComments()) {
            return orig;
        }
        try {
            Transform commentStripper = XMLUnit.getStripCommentsTransform(orig);
            return commentStripper.getResultDocument();
        }
        catch (TransformerException e) {
            throw new XMLUnitRuntimeException(e.getMessage(), e.getCause());
        }
    }

    private Document getNormalizedDocument(Document orig) {
        if (!XMLUnit.getNormalize()) {
            return orig;
        }
        Document d = (Document)orig.cloneNode(true);
        d.normalize();
        return d;
    }

    protected final void compare() {
        if (this.compared) {
            return;
        }
        this.getDifferenceEngine().compare(this.controlDoc, this.testDoc, this, this.elementQualifierDelegate);
        this.compared = true;
    }

    public boolean similar() {
        this.compare();
        return this.similar;
    }

    public boolean identical() {
        this.compare();
        return this.identical;
    }

    private void appendDifference(StringBuilder appendTo, Difference difference) {
        appendTo.append(' ').append(difference).append('\n');
    }

    @Override
    public int differenceFound(Difference difference) {
        int returnValue = this.evaluate(difference);
        switch (returnValue) {
            case 1: {
                return returnValue;
            }
            case 2: {
                this.identical = false;
                this.haltComparison = false;
                break;
            }
            case 0: {
                this.identical = false;
                if (difference.isRecoverable()) {
                    this.haltComparison = false;
                    break;
                }
                this.similar = false;
                this.haltComparison = true;
                break;
            }
            case 3: {
                this.similar = false;
                this.identical = false;
                this.haltComparison = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(returnValue + " is not a defined DifferenceListener.RETURN_... value");
            }
        }
        if (this.haltComparison) {
            this.messages.append("\n[different]");
        } else {
            this.messages.append("\n[not identical]");
        }
        this.appendDifference(this.messages, difference);
        return returnValue;
    }

    public int evaluate(Difference difference) {
        int returnValue = 0;
        if (this.differenceListenerDelegate != null) {
            returnValue = this.differenceListenerDelegate.differenceFound(difference);
        }
        return returnValue;
    }

    @Override
    public void skippedComparison(Node control, Node test) {
        if (this.differenceListenerDelegate != null) {
            this.differenceListenerDelegate.skippedComparison(control, test);
        } else {
            System.err.println("DifferenceListener.skippedComparison: unhandled control node type=" + control + ", unhandled test node type=" + test);
        }
    }

    @Override
    public boolean haltComparison(Difference afterDifference) {
        return this.haltComparison;
    }

    public StringBuffer appendMessage(StringBuffer toAppendTo) {
        this.compare();
        if (this.messages.length() == 0) {
            this.messages.append("[identical]");
        }
        return toAppendTo.append(this.messages.toString());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        this.appendMessage(buf);
        return buf.toString();
    }

    public void overrideDifferenceListener(DifferenceListener delegate) {
        this.differenceListenerDelegate = delegate;
    }

    public void overrideElementQualifier(ElementQualifier delegate) {
        this.elementQualifierDelegate = delegate;
    }

    public void overrideMatchTracker(MatchTracker delegate) {
        this.matchTrackerDelegate = delegate;
        if (this.differenceEngine != null) {
            this.differenceEngine.setMatchTracker(delegate);
        }
    }

    private DifferenceEngineContract getDifferenceEngine() {
        if (this.differenceEngine == null) {
            if (XMLUnit.getIgnoreAttributeOrder()) {
                return new NewDifferenceEngine(this, this.matchTrackerDelegate);
            }
            return new DifferenceEngine(this, this.matchTrackerDelegate);
        }
        return this.differenceEngine;
    }

    private static Document toDocument(DOMSource d) {
        Node n = d.getNode();
        return n instanceof Document ? (Document)n : n.getOwnerDocument();
    }
}

