/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.Format;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class FormatValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(FormatValidator.class);
    private final Format format;

    public FormatValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, Format format, ValidatorTypeCode type) {
        super(schemaPath, schemaNode, parentSchema, type, validationContext);
        this.format = format;
        this.validationContext = validationContext;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return errors;
        }
        if (this.format != null) {
            if (this.format.getName().equals("ipv6")) {
                if (!node.textValue().trim().equals(node.textValue())) {
                    errors.add(this.buildValidationMessage(at, this.format.getName(), this.format.getErrorMessageDescription()));
                } else if (node.textValue().contains("%")) {
                    errors.add(this.buildValidationMessage(at, this.format.getName(), this.format.getErrorMessageDescription()));
                }
            }
            try {
                if (!this.format.matches(node.textValue())) {
                    errors.add(this.buildValidationMessage(at, this.format.getName(), this.format.getErrorMessageDescription()));
                }
            }
            catch (PatternSyntaxException pse) {
                logger.error("Failed to apply pattern on {}: Invalid RE syntax [{}]", at, this.format.getName(), pse);
            }
        }
        return Collections.unmodifiableSet(errors);
    }
}

