/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.multipart.PartParser;
import com.github.tomakehurst.wiremock.jetty.JettyUtils;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigurer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.base.Supplier;
import wiremock.com.google.common.base.Suppliers;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.ImmutableMultimap;
import wiremock.com.google.common.collect.Maps;
import wiremock.com.google.common.io.ByteStreams;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.org.eclipse.jetty.server.Request;

public class WireMockHttpServletRequestAdapter
implements com.github.tomakehurst.wiremock.http.Request {
    public static final String ORIGINAL_REQUEST_KEY = "wiremock.ORIGINAL_REQUEST";
    private final HttpServletRequest request;
    private final MultipartRequestConfigurer multipartRequestConfigurer;
    private byte[] cachedBody;
    private final Supplier<Map<String, QueryParameter>> cachedQueryParams;
    private final Supplier<Map<String, FormParameter>> cachedFormParameters;
    private final boolean browserProxyingEnabled;
    private final String urlPrefixToRemove;
    private Collection<Request.Part> cachedMultiparts;

    public WireMockHttpServletRequestAdapter(HttpServletRequest request, MultipartRequestConfigurer multipartRequestConfigurer, String urlPrefixToRemove, boolean browserProxyingEnabled) {
        this.request = request;
        this.multipartRequestConfigurer = multipartRequestConfigurer;
        this.urlPrefixToRemove = urlPrefixToRemove;
        this.browserProxyingEnabled = browserProxyingEnabled;
        this.cachedQueryParams = Suppliers.memoize(() -> Urls.splitQuery(request.getQueryString()));
        this.cachedFormParameters = Suppliers.memoize(() -> this.getFormParameters(request));
        if (multipartRequestConfigurer != null) {
            this.multipartRequestConfigurer.configure(request);
        }
    }

    @Override
    public String getUrl() {
        String url = this.request.getRequestURI();
        String contextPath = this.request.getContextPath();
        if (!wiremock.com.google.common.base.Strings.isNullOrEmpty(contextPath) && url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        if (!wiremock.com.google.common.base.Strings.isNullOrEmpty(this.urlPrefixToRemove) && url.startsWith(this.urlPrefixToRemove)) {
            url = url.substring(this.urlPrefixToRemove.length());
        }
        return this.withQueryStringIfPresent(url);
    }

    @Override
    public String getAbsoluteUrl() {
        return this.withQueryStringIfPresent(this.request.getRequestURL().toString());
    }

    private String withQueryStringIfPresent(String url) {
        return url + (String)(wiremock.com.google.common.base.Strings.isNullOrEmpty(this.request.getQueryString()) ? "" : "?" + this.request.getQueryString());
    }

    @Override
    public RequestMethod getMethod() {
        return RequestMethod.fromString(this.request.getMethod().toUpperCase());
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getHost() {
        return this.request.getServerName();
    }

    @Override
    public int getPort() {
        return this.request.getServerPort();
    }

    @Override
    public String getClientIp() {
        String forwardedForHeader = this.getHeader("X-Forwarded-For");
        if (forwardedForHeader != null && forwardedForHeader.length() > 0) {
            return forwardedForHeader;
        }
        return this.request.getRemoteAddr();
    }

    @Override
    public byte[] getBody() {
        if (this.cachedBody == null) {
            try {
                byte[] body = ByteStreams.toByteArray(this.request.getInputStream());
                boolean isGzipped = this.hasGzipEncoding() || Gzip.isGzipped(body);
                this.cachedBody = isGzipped ? Gzip.unGzip(body) : body;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.cachedBody;
    }

    private Charset encodingFromContentTypeHeaderOrUtf8() {
        ContentTypeHeader contentTypeHeader = this.contentTypeHeader();
        if (contentTypeHeader != null) {
            return contentTypeHeader.charset();
        }
        return StandardCharsets.UTF_8;
    }

    private boolean hasGzipEncoding() {
        String encodingHeader = this.request.getHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.contains("gzip");
    }

    @Override
    public String getBodyAsString() {
        return Strings.stringFromBytes(this.getBody(), this.encodingFromContentTypeHeaderOrUtf8());
    }

    @Override
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.getBody());
    }

    @Override
    public String getHeader(String key) {
        return this.request.getHeader(key);
    }

    @Override
    public HttpHeader header(String key) {
        if (this.request.getHeader(key) == null) {
            return HttpHeader.absent(key);
        }
        ArrayList<String> valueList = Collections.list(this.request.getHeaders(key));
        if (valueList.isEmpty()) {
            return HttpHeader.empty(key);
        }
        return new HttpHeader(key, (Collection<String>)valueList);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        String firstValue = this.getHeader("Content-Type");
        return firstValue == null ? ContentTypeHeader.absent() : new ContentTypeHeader(firstValue);
    }

    @Override
    public boolean containsHeader(String key) {
        return this.header(key).isPresent();
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.request instanceof Request) {
            return WireMockHttpServletRequestAdapter.getHeadersLinear((Request)this.request);
        }
        return this.getHeadersQuadratic();
    }

    private static HttpHeaders getHeadersLinear(Request request) {
        List<HttpHeader> headers = request.getHttpFields().stream().map(field -> HttpHeader.httpHeader(field.getName(), field.getValue())).collect(Collectors.toList());
        return new HttpHeaders(headers);
    }

    private HttpHeaders getHeadersQuadratic() {
        ArrayList<HttpHeader> headerList = new ArrayList<HttpHeader>();
        for (String key : this.getAllHeaderKeys()) {
            headerList.add(this.header(key));
        }
        return new HttpHeaders(headerList);
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        LinkedHashSet<String> headerKeys = new LinkedHashSet<String>();
        Enumeration<String> headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            headerKeys.add(headerNames.nextElement());
        }
        return headerKeys;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        wiremock.jakarta.servlet.http.Cookie[] cookies;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        for (wiremock.jakarta.servlet.http.Cookie cookie : cookies = MoreObjects.firstNonNull(this.request.getCookies(), new wiremock.jakarta.servlet.http.Cookie[0])) {
            builder.put(cookie.getName(), cookie.getValue());
        }
        return Maps.transformValues(builder.build().asMap(), input -> new Cookie(null, ImmutableList.copyOf(input)));
    }

    @Override
    public QueryParameter queryParameter(String key) {
        Map<String, QueryParameter> queryParams = this.cachedQueryParams.get();
        return MoreObjects.firstNonNull(queryParams.get(key), QueryParameter.absent(key));
    }

    @Override
    public FormParameter formParameter(String key) {
        Map<String, FormParameter> formParameters = this.cachedFormParameters.get();
        return MoreObjects.firstNonNull(formParameters.get(key), FormParameter.absent(key));
    }

    @Override
    public Map<String, FormParameter> formParameters() {
        return this.cachedFormParameters.get();
    }

    @Override
    public boolean isBrowserProxyRequest() {
        if (!this.browserProxyingEnabled || !JettyUtils.isJetty()) {
            return false;
        }
        if (this.request instanceof Request) {
            Request jettyRequest = (Request)this.request;
            return JettyUtils.uriIsAbsolute(jettyRequest);
        }
        return false;
    }

    @Override
    public Collection<Request.Part> getParts() {
        if (!this.isMultipart()) {
            return null;
        }
        if (this.cachedMultiparts == null) {
            this.cachedMultiparts = PartParser.parseFrom(this);
        }
        return this.cachedMultiparts.size() > 0 ? this.cachedMultiparts : null;
    }

    @Override
    public boolean isMultipart() {
        String header = this.getHeader("Content-Type");
        return header != null && header.contains("multipart/");
    }

    @Override
    public Request.Part getPart(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (this.cachedMultiparts == null && this.getParts() == null) {
            return null;
        }
        return this.cachedMultiparts.stream().filter(part -> name.equals(part.getName())).findFirst().orElse(null);
    }

    @Override
    public Optional<com.github.tomakehurst.wiremock.http.Request> getOriginalRequest() {
        com.github.tomakehurst.wiremock.http.Request originalRequest = (com.github.tomakehurst.wiremock.http.Request)this.request.getAttribute(ORIGINAL_REQUEST_KEY);
        return Optional.ofNullable(originalRequest);
    }

    public String toString() {
        return this.request.toString() + this.getBodyAsString();
    }

    @Override
    public String getProtocol() {
        return this.request.getProtocol();
    }

    private Map<String, FormParameter> getFormParameters(HttpServletRequest request) {
        Map<String, QueryParameter> queryParameters = this.cachedQueryParams.get();
        return request.getParameterMap().entrySet().stream().filter(entry -> queryParameters == null || !queryParameters.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> FormParameter.formParam((String)entry.getKey(), (String[])entry.getValue())));
    }
}

