/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.multipart;

import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import java.util.Iterator;
import java.util.function.Function;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.Iterators;
import wiremock.org.apache.commons.fileupload.FileItem;
import wiremock.org.apache.commons.fileupload.FileItemHeaders;

public class FileItemPartAdapter
implements Request.Part {
    private final FileItem fileItem;
    public static final Function<FileItem, Request.Part> TO_PARTS = FileItemPartAdapter::new;

    public FileItemPartAdapter(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    @Override
    public String getName() {
        return this.fileItem.getFieldName();
    }

    @Override
    public HttpHeader getHeader(String name) {
        Iterator<String> headerValues = this.fileItem.getHeaders().getHeaders(name);
        return new HttpHeader(name, Iterators.toArray(headerValues, String.class));
    }

    @Override
    public HttpHeaders getHeaders() {
        FileItemHeaders headers = this.fileItem.getHeaders();
        Iterator<String> i = headers.getHeaderNames();
        ImmutableList.Builder builder = ImmutableList.builder();
        while (i.hasNext()) {
            String name = i.next();
            builder.add(this.getHeader(name));
        }
        return new HttpHeaders(builder.build());
    }

    @Override
    public Body getBody() {
        return new Body(this.fileItem.get());
    }
}

