/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import wiremock.org.apache.commons.lang3.StringUtils;
import wiremock.org.apache.commons.lang3.text.WordUtils;

public class Strings {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private Strings() {
    }

    public static String stringFromBytes(byte[] bytes) {
        return Strings.stringFromBytes(bytes, DEFAULT_CHARSET);
    }

    public static String stringFromBytes(byte[] bytes, Charset charset) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, charset);
    }

    public static byte[] bytesFromString(String str) {
        return Strings.bytesFromString(str, DEFAULT_CHARSET);
    }

    public static byte[] bytesFromString(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        return str.getBytes(charset);
    }

    public static String wrapIfLongestLineExceedsLimit(String s2, int maxLineLength) {
        int longestLength = Strings.findLongestLineLength(s2);
        if (longestLength > maxLineLength) {
            String wrapped = WordUtils.wrap(s2, maxLineLength, null, true);
            return wrapped.replaceAll("(?m)^[ \t]*\r?\n", "");
        }
        return s2;
    }

    private static int findLongestLineLength(String s2) {
        String[] lines = s2.split("\n");
        int longestLength = 0;
        for (String line : lines) {
            int length = line.length();
            if (length <= longestLength) continue;
            longestLength = length;
        }
        return longestLength;
    }

    public static double normalisedLevenshteinDistance(String one, String two) {
        if (one == null || two == null) {
            return 1.0;
        }
        double maxDistance = Math.max(one.length(), two.length());
        double actualDistance = StringUtils.getLevenshteinDistance(one, two);
        return actualDistance / maxDistance;
    }

    public static String normaliseLineBreaks(String s2) {
        return s2.replace("\r\n", "\n").replace("\n", System.lineSeparator());
    }
}

