/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.Conversions;
import com.github.tomakehurst.wiremock.admin.Paginator;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.base.Preconditions;

public class LimitAndSinceDatePaginator
implements Paginator<ServeEvent> {
    private final List<ServeEvent> source;
    private final Integer limit;
    private final Date since;

    public LimitAndSinceDatePaginator(List<ServeEvent> source, Integer limit, Date since) {
        Preconditions.checkArgument(limit == null || limit >= 0, "limit must be 0 or greater");
        this.source = source;
        this.limit = limit;
        this.since = since;
    }

    public static LimitAndSinceDatePaginator fromRequest(List<ServeEvent> source, Request request) {
        return new LimitAndSinceDatePaginator(source, Conversions.toInt(request.queryParameter("limit")), Conversions.toDate(request.queryParameter("since")));
    }

    @Override
    public List<ServeEvent> select() {
        return this.source.stream().filter(input -> this.since == null || input.getRequest().getLoggedDate().after(this.since)).limit(MoreObjects.firstNonNull(this.limit, this.source.size()).intValue()).collect(Collectors.toList());
    }

    @Override
    public int getTotal() {
        return this.source.size();
    }
}

