/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.io;

import java.io.IOException;
import java.util.Map;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;

public interface ClientConnectionFactory {
    public Connection newConnection(EndPoint var1, Map<String, Object> var2) throws IOException;

    public static class Helper {
        private static Logger LOG = Log.getLogger(Helper.class);

        private Helper() {
        }

        public static void replaceConnection(Connection oldConnection, Connection newConnection) {
            Helper.close(oldConnection);
            oldConnection.getEndPoint().setConnection(newConnection);
            Helper.open(newConnection);
        }

        private static void open(Connection connection) {
            try {
                connection.onOpen();
            }
            catch (Throwable x) {
                LOG.debug(x);
            }
        }

        private static void close(Connection connection) {
            try {
                connection.onClose();
            }
            catch (Throwable x) {
                LOG.debug(x);
            }
        }
    }
}

