/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.AbstractFileSource;
import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.SafeNames;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.standalone.MappingsSource;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import wiremock.com.google.common.collect.Iterables;

public class JsonFileMappingsSource
implements MappingsSource {
    private final FileSource mappingsFileSource;
    private final Map<UUID, String> fileNameMap;

    public JsonFileMappingsSource(FileSource mappingsFileSource) {
        this.mappingsFileSource = mappingsFileSource;
        this.fileNameMap = new HashMap<UUID, String>();
    }

    @Override
    public void save(List<StubMapping> stubMappings) {
        for (StubMapping mapping : stubMappings) {
            if (mapping == null || !mapping.isDirty()) continue;
            this.save(mapping);
        }
    }

    @Override
    public void save(StubMapping stubMapping) {
        String mappingFileName = this.fileNameMap.get(stubMapping.getId());
        if (mappingFileName == null) {
            mappingFileName = SafeNames.makeSafeFileName(stubMapping);
        }
        this.mappingsFileSource.writeTextFile(mappingFileName, Json.write(stubMapping));
        this.fileNameMap.put(stubMapping.getId(), mappingFileName);
        stubMapping.setDirty(false);
    }

    @Override
    public void remove(StubMapping stubMapping) {
        String mappingFileName = this.fileNameMap.get(stubMapping.getId());
        this.mappingsFileSource.deleteFile(mappingFileName);
        this.fileNameMap.remove(stubMapping.getId());
    }

    @Override
    public void removeAll() {
        for (String filename : this.fileNameMap.values()) {
            this.mappingsFileSource.deleteFile(filename);
        }
        this.fileNameMap.clear();
    }

    @Override
    public void loadMappingsInto(StubMappings stubMappings) {
        if (!this.mappingsFileSource.exists()) {
            return;
        }
        Iterable<BinaryFile> mappingFiles = Iterables.filter(this.mappingsFileSource.listFilesRecursively(), AbstractFileSource.byFileExtension("json"));
        for (TextFile textFile : mappingFiles) {
            StubMapping mapping = StubMapping.buildFrom(textFile.readContentsAsString());
            mapping.setDirty(false);
            stubMappings.addMapping(mapping);
            this.fileNameMap.put(mapping.getId(), textFile.getUri().getSchemeSpecificPart());
        }
    }
}

