/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.ssl;

import com.github.tomakehurst.wiremock.http.ssl.CertChainAndKey;
import com.github.tomakehurst.wiremock.http.ssl.CertificateAuthority;
import com.github.tomakehurst.wiremock.http.ssl.CertificateGenerationUnsupportedException;
import com.github.tomakehurst.wiremock.http.ssl.X509KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.SNIHostName;

public class DynamicKeyStore {
    private final X509KeyStore keyStore;
    private final CertificateAuthority existingCertificateAuthority;

    public DynamicKeyStore(X509KeyStore keyStore) {
        this.keyStore = Objects.requireNonNull(keyStore);
        this.existingCertificateAuthority = Objects.requireNonNull(keyStore.getCertificateAuthority(), "Keystore does not contain a certificate that can act as a certificate authority");
    }

    PrivateKey getPrivateKey(String alias) {
        return this.keyStore.getPrivateKey(alias);
    }

    X509Certificate[] getCertificateChain(String alias) {
        return this.keyStore.getCertificateChain(alias);
    }

    void generateCertificateIfNecessary(String keyType, SNIHostName requestedServerName) throws CertificateGenerationUnsupportedException, KeyStoreException {
        if (this.getPrivateKey(requestedServerName.getAsciiName()) == null) {
            this.generateCertificate(keyType, requestedServerName);
        }
    }

    private void generateCertificate(String keyType, SNIHostName requestedServerName) throws CertificateGenerationUnsupportedException, KeyStoreException {
        CertChainAndKey newCertChainAndKey = this.existingCertificateAuthority.generateCertificate(keyType, requestedServerName);
        this.keyStore.setKeyEntry(requestedServerName.getAsciiName(), newCertChainAndKey);
    }
}

