/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.StubLifecycleListener;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HandlebarsOptimizedTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HttpTemplateCacheKey;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ResponseTemplateTransformer
extends ResponseDefinitionTransformer
implements StubLifecycleListener {
    public static final String NAME = "response-template";
    private final boolean global;
    private final TemplateEngine templateEngine;

    public static Builder builder() {
        return new Builder();
    }

    public ResponseTemplateTransformer(boolean global) {
        this(global, Collections.emptyMap());
    }

    public ResponseTemplateTransformer(boolean global, String helperName, Helper<?> helper) {
        this(global, (Map<String, Helper<?>>)ImmutableMap.of((Object)helperName, helper));
    }

    public ResponseTemplateTransformer(boolean global, Map<String, Helper<?>> helpers) {
        this(global, new Handlebars(), helpers, null, null);
    }

    public ResponseTemplateTransformer(boolean global, Handlebars handlebars, Map<String, Helper<?>> helpers, Long maxCacheEntries, Set<String> permittedSystemKeys) {
        this.global = global;
        this.templateEngine = new TemplateEngine(handlebars, helpers, maxCacheEntries, permittedSystemKeys);
    }

    @Override
    public boolean applyGlobally() {
        return this.global;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
        ResponseDefinitionBuilder newResponseDefBuilder = ResponseDefinitionBuilder.like(responseDefinition);
        ImmutableMap model = ImmutableMap.builder().put((Object)"parameters", MoreObjects.firstNonNull((Object)parameters, Collections.emptyMap())).put((Object)"request", (Object)RequestTemplateModel.from(request)).putAll(this.addExtraModelElements(request, responseDefinition, files, parameters)).build();
        if (responseDefinition.specifiesTextBodyContent()) {
            boolean isJsonBody = responseDefinition.getJsonBody() != null;
            HandlebarsOptimizedTemplate bodyTemplate = this.templateEngine.getTemplate(HttpTemplateCacheKey.forInlineBody(responseDefinition), responseDefinition.getTextBody());
            this.applyTemplatedResponseBody(newResponseDefBuilder, (ImmutableMap<String, Object>)model, bodyTemplate, isJsonBody);
        } else if (responseDefinition.specifiesBodyFile()) {
            HandlebarsOptimizedTemplate filePathTemplate = this.templateEngine.getUncachedTemplate(responseDefinition.getBodyFileName());
            String compiledFilePath = this.uncheckedApplyTemplate(filePathTemplate, model);
            boolean disableBodyFileTemplating = parameters.getBoolean("disableBodyFileTemplating", false);
            if (disableBodyFileTemplating) {
                newResponseDefBuilder.withBodyFile(compiledFilePath);
            } else {
                TextFile file = files.getTextFileNamed(compiledFilePath);
                HandlebarsOptimizedTemplate bodyTemplate = this.templateEngine.getTemplate(HttpTemplateCacheKey.forFileBody(responseDefinition, compiledFilePath), file.readContentsAsString());
                this.applyTemplatedResponseBody(newResponseDefBuilder, (ImmutableMap<String, Object>)model, bodyTemplate, false);
            }
        }
        if (responseDefinition.getHeaders() != null) {
            Iterable newResponseHeaders = Iterables.transform(responseDefinition.getHeaders().all(), header -> {
                ImmutableList.Builder valueListBuilder = ImmutableList.builder();
                int index = 0;
                for (String headerValue : header.values()) {
                    HandlebarsOptimizedTemplate template = this.templateEngine.getTemplate(HttpTemplateCacheKey.forHeader(responseDefinition, header.key(), index++), headerValue);
                    valueListBuilder.add((Object)this.uncheckedApplyTemplate(template, model));
                }
                return new HttpHeader(header.key(), (Collection<String>)valueListBuilder.build());
            });
            newResponseDefBuilder.withHeaders(new HttpHeaders(newResponseHeaders));
        }
        if (responseDefinition.getProxyBaseUrl() != null) {
            HandlebarsOptimizedTemplate proxyBaseUrlTemplate = this.templateEngine.getTemplate(HttpTemplateCacheKey.forProxyUrl(responseDefinition), responseDefinition.getProxyBaseUrl());
            String newProxyBaseUrl = this.uncheckedApplyTemplate(proxyBaseUrlTemplate, model);
            ResponseDefinitionBuilder.ProxyResponseDefinitionBuilder newProxyResponseDefBuilder = newResponseDefBuilder.proxiedFrom(newProxyBaseUrl);
            if (responseDefinition.getAdditionalProxyRequestHeaders() != null) {
                Iterable newResponseHeaders = Iterables.transform(responseDefinition.getAdditionalProxyRequestHeaders().all(), header -> {
                    ImmutableList.Builder valueListBuilder = ImmutableList.builder();
                    int index = 0;
                    for (String headerValue : header.values()) {
                        HandlebarsOptimizedTemplate template = this.templateEngine.getTemplate(HttpTemplateCacheKey.forHeader(responseDefinition, header.key(), index++), headerValue);
                        valueListBuilder.add((Object)this.uncheckedApplyTemplate(template, model));
                    }
                    return new HttpHeader(header.key(), (Collection<String>)valueListBuilder.build());
                });
                HttpHeaders proxyHttpHeaders = new HttpHeaders(newResponseHeaders);
                for (String key : proxyHttpHeaders.keys()) {
                    newProxyResponseDefBuilder.withAdditionalRequestHeader(key, proxyHttpHeaders.getHeader(key).firstValue());
                }
            }
            return newProxyResponseDefBuilder.build();
        }
        return newResponseDefBuilder.build();
    }

    protected Map<String, Object> addExtraModelElements(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
        return Collections.emptyMap();
    }

    private void applyTemplatedResponseBody(ResponseDefinitionBuilder newResponseDefBuilder, ImmutableMap<String, Object> model, HandlebarsOptimizedTemplate bodyTemplate, boolean isJsonBody) {
        String newBody = this.uncheckedApplyTemplate(bodyTemplate, model);
        if (isJsonBody) {
            newResponseDefBuilder.withJsonBody(Json.read(newBody, JsonNode.class));
        } else {
            newResponseDefBuilder.withBody(newBody);
        }
    }

    private String uncheckedApplyTemplate(HandlebarsOptimizedTemplate template, Object context) {
        return template.apply(context);
    }

    @Override
    public void beforeStubCreated(StubMapping stub) {
    }

    @Override
    public void afterStubCreated(StubMapping stub) {
    }

    @Override
    public void beforeStubEdited(StubMapping oldStub, StubMapping newStub) {
    }

    @Override
    public void afterStubEdited(StubMapping oldStub, StubMapping newStub) {
    }

    @Override
    public void beforeStubRemoved(StubMapping stub) {
    }

    @Override
    public void afterStubRemoved(StubMapping stub) {
        this.templateEngine.invalidateCache();
    }

    @Override
    public void beforeStubsReset() {
    }

    @Override
    public void afterStubsReset() {
        this.templateEngine.invalidateCache();
    }

    public long getCacheSize() {
        return this.templateEngine.getCacheSize();
    }

    public Long getMaxCacheEntries() {
        return this.templateEngine.getMaxCacheEntries();
    }

    public static class Builder {
        private boolean global = true;
        private Handlebars handlebars = new Handlebars();
        private Map<String, Helper<?>> helpers = new HashMap();
        private Long maxCacheEntries = null;
        private Set<String> permittedSystemKeys = null;

        public Builder global(boolean global) {
            this.global = global;
            return this;
        }

        public Builder handlebars(Handlebars handlebars) {
            this.handlebars = handlebars;
            return this;
        }

        public Builder helpers(Map<String, Helper<?>> helpers) {
            this.helpers = helpers;
            return this;
        }

        public Builder helper(String name, Helper<?> helper) {
            this.helpers.put(name, helper);
            return this;
        }

        public Builder maxCacheEntries(Long maxCacheEntries) {
            this.maxCacheEntries = maxCacheEntries;
            return this;
        }

        public Builder permittedSystemKeys(Set<String> keys) {
            this.permittedSystemKeys = keys;
            return this;
        }

        public Builder permittedSystemKeys(String ... keys) {
            this.permittedSystemKeys = ImmutableSet.copyOf((Object[])keys);
            return this;
        }

        public ResponseTemplateTransformer build() {
            return new ResponseTemplateTransformer(this.global, this.handlebars, this.helpers, this.maxCacheEntries, this.permittedSystemKeys);
        }
    }
}

