/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.http2.frames.PriorityFrame;

public class HeaderBlockFragments {
    private PriorityFrame priorityFrame;
    private boolean endStream;
    private int streamId;
    private ByteBuffer storage;

    public void storeFragment(ByteBuffer fragment, int length, boolean last) {
        int space;
        if (this.storage == null) {
            space = last ? length : length * 2;
            this.storage = ByteBuffer.allocate(space);
        }
        if (this.storage.remaining() < length) {
            space = last ? length : length * 2;
            int capacity = this.storage.position() + space;
            ByteBuffer newStorage = ByteBuffer.allocate(capacity);
            this.storage.flip();
            newStorage.put(this.storage);
            this.storage = newStorage;
        }
        int limit = fragment.limit();
        fragment.limit(fragment.position() + length);
        this.storage.put(fragment);
        fragment.limit(limit);
    }

    public PriorityFrame getPriorityFrame() {
        return this.priorityFrame;
    }

    public void setPriorityFrame(PriorityFrame priorityFrame) {
        this.priorityFrame = priorityFrame;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    public void setEndStream(boolean endStream) {
        this.endStream = endStream;
    }

    public ByteBuffer complete() {
        ByteBuffer result = this.storage;
        this.storage = null;
        result.flip();
        return result;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }
}

