/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.InputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import wiremock.com.google.common.io.ByteStreams;

public class BinaryFile
implements InputStreamSource {
    private URI uri;

    public BinaryFile(URI uri) {
        this.uri = uri;
    }

    public byte[] readContents() {
        byte[] byArray;
        block8: {
            InputStream stream = this.getStream();
            try {
                byArray = ByteStreams.toByteArray(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    return Exceptions.throwUnchecked(ioe, byte[].class);
                }
            }
            stream.close();
        }
        return byArray;
    }

    protected URI getUri() {
        return this.uri;
    }

    public String name() {
        return this.uri.toString();
    }

    public String toString() {
        return this.name();
    }

    @Override
    public InputStream getStream() {
        try {
            return this.uri.toURL().openStream();
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, InputStream.class);
        }
    }
}

