/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.NetworkAddressRange;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import wiremock.com.google.common.collect.ImmutableSet;
import wiremock.com.google.common.net.InetAddresses;

public class NetworkAddressRules {
    private final Set<NetworkAddressRange> allowed;
    private final Set<NetworkAddressRange> allowedHostPatterns;
    private final Set<NetworkAddressRange> denied;
    private final Set<NetworkAddressRange> deniedHostPatterns;
    public static NetworkAddressRules ALLOW_ALL = new NetworkAddressRules(ImmutableSet.of(NetworkAddressRange.ALL), Collections.emptySet());

    public static Builder builder() {
        return new Builder();
    }

    public NetworkAddressRules(Set<NetworkAddressRange> allowed, Set<NetworkAddressRange> denied) {
        this.allowed = NetworkAddressRules.defaultIfEmpty(allowed.stream().filter(networkAddressRange -> !(networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard)).collect(Collectors.toSet()), ImmutableSet.of(NetworkAddressRange.ALL));
        this.allowedHostPatterns = NetworkAddressRules.defaultIfEmpty(allowed.stream().filter(networkAddressRange -> networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard).collect(Collectors.toSet()), ImmutableSet.of(NetworkAddressRange.ALL));
        this.denied = denied.stream().filter(networkAddressRange -> !(networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard)).collect(Collectors.toSet());
        this.deniedHostPatterns = denied.stream().filter(networkAddressRange -> networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard).map(networkAddressRange -> (NetworkAddressRange.DomainNameWildcard)networkAddressRange).collect(Collectors.toSet());
    }

    private static <T> Set<T> defaultIfEmpty(Set<T> original, Set<T> ifEmpty) {
        if (original.isEmpty()) {
            return ifEmpty;
        }
        return original;
    }

    public boolean isAllowed(String testValue) {
        if (InetAddresses.isInetAddress(testValue)) {
            return this.allowed.stream().anyMatch(rule -> rule.isIncluded(testValue)) && this.denied.stream().noneMatch(rule -> rule.isIncluded(testValue));
        }
        return this.allowedHostPatterns.stream().anyMatch(rule -> rule.isIncluded(testValue)) && this.deniedHostPatterns.stream().noneMatch(rule -> rule.isIncluded(testValue));
    }

    public static class Builder {
        private final ImmutableSet.Builder<NetworkAddressRange> allowed = ImmutableSet.builder();
        private final ImmutableSet.Builder<NetworkAddressRange> denied = ImmutableSet.builder();

        public Builder allow(String expression) {
            this.allowed.add((Object)NetworkAddressRange.of(expression));
            return this;
        }

        public Builder deny(String expression) {
            this.denied.add((Object)NetworkAddressRange.of(expression));
            return this;
        }

        public NetworkAddressRules build() {
            ImmutableSet<NetworkAddressRange> allowedRanges = this.allowed.build();
            if (allowedRanges.isEmpty()) {
                allowedRanges = ImmutableSet.of(NetworkAddressRange.ALL);
            }
            return new NetworkAddressRules(allowedRanges, (Set<NetworkAddressRange>)((Object)this.denied.build()));
        }
    }
}

