/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateOffset {
    private final Unit timeUnit;
    private final int amount;

    public DateOffset(String offset) {
        String[] parts = offset.split(" ");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Offset must be of the form <amount> <unit> e.g. 8 seconds");
        }
        this.amount = Integer.parseInt(parts[0]);
        this.timeUnit = Unit.valueOf(parts[1].toUpperCase());
    }

    public Unit getTimeUnit() {
        return this.timeUnit;
    }

    public int getAmount() {
        return this.amount;
    }

    public Date shift(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Z"));
        calendar.setTime(date);
        calendar.add(this.timeUnit.calendarField, this.amount);
        return calendar.getTime();
    }

    public static enum Unit {
        SECONDS(13),
        MINUTES(12),
        HOURS(10),
        DAYS(5),
        MONTHS(2),
        YEARS(1);

        private final int calendarField;

        private Unit(int calendarField) {
            this.calendarField = calendarField;
        }

        public int getCalendarField() {
            return this.calendarField;
        }
    }
}

