/*
 * Decompiled with CFR 0.152.
 */
package redis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import redis.util.BytesKey;
import redis.util.BytesKeyObjectMap;
import redis.util.ZSetEntry;

public class ZSet
implements Iterable<ZSetEntry> {
    private static final BytesKey EMPTY = new BytesKey(new byte[0]);
    private BytesKeyObjectMap<ZSetEntry> map = new BytesKeyObjectMap();
    private List<ZSetEntry> list = new ArrayList<ZSetEntry>();

    public ZSet(ZSet destination) {
        this.map.putAll(destination.map);
        this.list.addAll(destination.list);
    }

    public ZSet() {
    }

    public int size() {
        return this.list.size();
    }

    public ZSetEntry get(byte[] member2) {
        return this.map.get(member2);
    }

    public boolean remove(byte[] member2) {
        return this.remove(new BytesKey(member2));
    }

    @Override
    public Iterator<ZSetEntry> iterator() {
        return this.list.iterator();
    }

    public ZSetEntry get(BytesKey key) {
        return this.map.get(key);
    }

    public List<ZSetEntry> list() {
        return this.list;
    }

    public void addAll(ZSet other) {
        for (ZSetEntry zSetEntry : other.list) {
            this.remove(zSetEntry.getKey());
            this.add(zSetEntry.getKey(), zSetEntry.getScore());
        }
    }

    public boolean remove(BytesKey key) {
        ZSetEntry current = this.map.get(key);
        if (current != null) {
            this.map.remove(key);
            int index = Collections.binarySearch(this.list, current);
            this.list.remove(index);
        }
        return current == null;
    }

    public boolean add(BytesKey key, double score) {
        ZSetEntry current = this.map.get(key);
        if (current != null) {
            this.map.remove(key);
            int index = Collections.binarySearch(this.list, current);
            this.list.remove(index);
        }
        ZSetEntry entry = new ZSetEntry(key, score);
        this.map.put(key, entry);
        int index = this.find(Collections.binarySearch(this.list, entry));
        this.list.add(index, entry);
        return current == null;
    }

    public Iterable<ZSetEntry> subSet(final int minIndex, int maxIndex) {
        final int finalMaxIndex = Math.min(maxIndex, this.list.size() - 1);
        return new Iterable<ZSetEntry>(){

            @Override
            public Iterator<ZSetEntry> iterator() {
                return new Iterator<ZSetEntry>(){
                    int min;
                    {
                        this.min = minIndex;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.min <= finalMaxIndex;
                    }

                    @Override
                    public ZSetEntry next() {
                        return (ZSetEntry)ZSet.this.list.get(this.min++);
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    public List<ZSetEntry> subSet(double min, double max) {
        int minIndex = this.find(Collections.binarySearch(this.list, new ZSetEntry(EMPTY, min)));
        int maxIndex = this.find(Collections.binarySearch(this.list, new ZSetEntry(EMPTY, max)));
        if (this.list.get(maxIndex).getScore() > max) {
            --maxIndex;
        }
        return this.list.subList(minIndex, maxIndex + 1);
    }

    private int find(int minIndex) {
        return minIndex < 0 ? -(minIndex + 1) : minIndex;
    }

    private static class ScoreComparator
    implements Comparator<ZSetEntry> {
        private ScoreComparator() {
        }

        @Override
        public int compare(ZSetEntry o1, ZSetEntry o2) {
            double value = o1.getScore() - o2.getScore();
            return value < 0.0 ? -1 : (value == (double)o1.getKey().compareTo(o2.getKey()) ? 0 : 1);
        }
    }
}

