/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StubOverrideFixer {
    private static final Logger logger = LoggerFactory.getLogger(StubOverrideFixer.class);
    private static final Set<String> GROOVY_METHODS = Set.of("getMetaClass", "setMetaClass", "invokeMethod", "getProperty", "setProperty");

    public static void main(String[] args) throws IOException {
        Path stubsDir = Path.of(args[0], new String[0]);
        try (Stream<Path> stream = Files.walk(stubsDir, new FileVisitOption[0]);){
            stream.filter(p -> p.toString().endsWith(".java")).forEach(StubOverrideFixer::processStub);
        }
    }

    private static void processStub(Path filePath) {
        try {
            CompilationUnit cu = StaticJavaParser.parse((Path)filePath);
            cu.findAll(MethodDeclaration.class).forEach(method -> {
                if (StubOverrideFixer.shouldHaveOverride(method)) {
                    method.addAnnotation("java.lang.Override");
                }
            });
            Files.write(filePath, cu.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (ParseProblemException | IOException e) {
            logger.error("Error processing: {} - {}", (Object)filePath, (Object)e.getMessage());
        }
    }

    private static boolean shouldHaveOverride(MethodDeclaration method) {
        return GROOVY_METHODS.contains(method.getNameAsString());
    }
}

