/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.CharNode;
import com.github.sisyphsu.retree.Node;

public final class CharTypeNode
extends CharNode {
    public static final int DIGIT = 1;
    public static final int SPACE = 2;
    public static final int WORD = 3;
    private final int ctype;
    private static final boolean[] DIGIT_MAP;
    private static final boolean[] WORD_MAP;
    private static final boolean[] SPACE_MAP;

    public CharTypeNode(int ctype, boolean matched) {
        super(matched);
        this.ctype = ctype;
    }

    @Override
    protected boolean isMatch(int ch) {
        if (ch < 128) {
            switch (this.ctype) {
                case 1: {
                    return DIGIT_MAP[ch];
                }
                case 3: {
                    return WORD_MAP[ch];
                }
            }
            return SPACE_MAP[ch];
        }
        return false;
    }

    @Override
    public boolean alike(Node node) {
        return node instanceof CharTypeNode && this.ctype == ((CharTypeNode)node).ctype && this.matched == ((CharTypeNode)node).matched;
    }

    static {
        int i;
        DIGIT_MAP = new boolean[128];
        WORD_MAP = new boolean[128];
        SPACE_MAP = new boolean[128];
        for (i = 48; i <= 57; ++i) {
            CharTypeNode.DIGIT_MAP[i] = true;
            CharTypeNode.WORD_MAP[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            CharTypeNode.WORD_MAP[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            CharTypeNode.WORD_MAP[i] = true;
        }
        for (i = 9; i <= 13; ++i) {
            CharTypeNode.SPACE_MAP[i] = true;
        }
        CharTypeNode.WORD_MAP[95] = true;
        CharTypeNode.SPACE_MAP[32] = true;
    }
}

