/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.dateparser;

import com.github.sisyphsu.dateparser.DateParser;
import com.github.sisyphsu.dateparser.DateParserBuilder;
import com.github.sisyphsu.dateparser.RuleHandler;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.Date;

public final class DateParserUtils {
    private static final DateParserBuilder builder = DateParser.newBuilder();
    private static DateParser dateParser = builder.build();

    private DateParserUtils() {
    }

    public static synchronized Date parseDate(String str) {
        return dateParser.parseDate(str);
    }

    public static synchronized Calendar parseCalendar(String str) {
        return dateParser.parseCalendar(str);
    }

    public static synchronized LocalDateTime parseDateTime(String str) {
        return dateParser.parseDateTime(str);
    }

    public static synchronized OffsetDateTime parseOffsetDateTime(String str) {
        return dateParser.parseOffsetDateTime(str);
    }

    public static synchronized void preferMonthFirst(boolean preferMonthFirst) {
        dateParser.setPreferMonthFirst(preferMonthFirst);
    }

    public static synchronized void registerStandardRule(String re) {
        builder.addRule(re);
        dateParser = builder.build();
    }

    public static synchronized void registerCustomizedRule(String re, RuleHandler handler) {
        builder.addRule(re, handler);
        dateParser = builder.build();
    }
}

