/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.dateparser;

import com.github.sisyphsu.dateparser.DateParser;
import com.github.sisyphsu.dateparser.RuleHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public final class DateParserBuilder {
    static final String[] months = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    static final String[] weeks = new String[]{"monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "mon", "tue", "wed", "thu", "fri", "sat", "sun"};
    static final List<String> STANDARD_RULES = new ArrayList<String>();
    static final List<String> CUSTOMIZED_RULES = new ArrayList<String>();
    static final Map<String, RuleHandler> CUSTOMIZED_RULE_MAP = new HashMap<String, RuleHandler>();
    private boolean preferMonthFirst = false;
    private final List<String> rules = new ArrayList<String>();
    private final Set<String> standardRules = new HashSet<String>();
    private final Map<String, RuleHandler> customizedRuleMap = new HashMap<String, RuleHandler>();

    static synchronized void register(String re) {
        if (!STANDARD_RULES.contains(re)) {
            STANDARD_RULES.add(re);
        }
    }

    static synchronized void register(String re, RuleHandler handler) {
        if (!CUSTOMIZED_RULE_MAP.containsKey(re)) {
            CUSTOMIZED_RULES.add(re);
        }
        CUSTOMIZED_RULE_MAP.put(re, handler);
    }

    DateParserBuilder() {
        this.rules.addAll(STANDARD_RULES);
        this.standardRules.addAll(STANDARD_RULES);
        this.rules.addAll(CUSTOMIZED_RULES);
        this.customizedRuleMap.putAll(CUSTOMIZED_RULE_MAP);
    }

    public DateParserBuilder preferMonthFirst(boolean preferMonthFirst) {
        this.preferMonthFirst = preferMonthFirst;
        return this;
    }

    public DateParserBuilder addRule(String rule) {
        if (!this.standardRules.contains(rule)) {
            this.rules.add(rule);
            this.standardRules.add(rule);
        }
        return this;
    }

    public DateParserBuilder addRule(String rule, RuleHandler handler) {
        if (!this.customizedRuleMap.containsKey(rule)) {
            this.rules.add(rule);
        }
        this.customizedRuleMap.put(rule, handler);
        return this;
    }

    public DateParser build() {
        return new DateParser(this.rules, this.standardRules, this.customizedRuleMap, this.preferMonthFirst);
    }

    static {
        for (String week : weeks) {
            DateParserBuilder.register(String.format("(?<week>%s)\\W*", week));
        }
        for (String month : months) {
            DateParserBuilder.register(String.format("(?<month>%s)\\W+(?<day>\\d{1,2})(?:th)?\\W+(?<year>\\d{4})\\b", month));
            DateParserBuilder.register(String.format("(?<month>%s)\\W+(?<day>\\d{1,2})(?:th)?\\W+(?<year>\\d{2})$", month));
            DateParserBuilder.register(String.format("(?<month>%s)\\W+(?<day>\\d{1,2})(?:th)?\\W+(?<year>\\d{2})[^:\\d]", month));
            DateParserBuilder.register(String.format("(?<month>%s)\\W+(?<day>\\d{1,2})(?:th)?\\b", month));
            DateParserBuilder.register(String.format("(?<day>\\d{1,2})(?:th)?\\W+(?<month>%s)\\W+(?<year>\\d{4})\\b", month));
            DateParserBuilder.register(String.format("(?<day>\\d{1,2})(?:th)?\\W+(?<month>%s)\\W+(?<year>\\d{2})$", month));
            DateParserBuilder.register(String.format("(?<day>\\d{1,2})(?:th)?\\W+(?<month>%s)\\W+(?<year>\\d{2})[^:\\d]", month));
            DateParserBuilder.register(String.format("(?<day>\\d{1,2})(?:th)?\\W+(?<month>%s)\\W*", month));
            DateParserBuilder.register(String.format("(?<year>\\d{4})\\W+(?<month>%s)\\W+(?<day>\\d{1,2})(?:th)?\\W*", month));
        }
        DateParserBuilder.register("(?<year>\\d{4})\\W{1}(?<month>\\d{1,2})\\W{1}(?<day>\\d{1,2})[^\\d]?");
        DateParserBuilder.register("^(?<year>\\d{4})\\W{1}(?<month>\\d{1,2})$");
        DateParserBuilder.register("(?<dayOrMonth>\\d{1,2}\\W{1}\\d{1,2})\\W{1}(?<year>\\d{4})[^\\d]?");
        DateParserBuilder.register("(?<dayOrMonth>\\d{1,2}[./]\\d{1,2})[./](?<year>\\d{2})$");
        DateParserBuilder.register("(?<dayOrMonth>\\d{1,2}[./]\\d{1,2})[./](?<year>\\d{2})[^:\\d]");
        DateParserBuilder.register(" ?(?<year>\\d{4})$");
        DateParserBuilder.register("^(?<year>\\d{4})(?<month>\\d{2})$");
        DateParserBuilder.register("^(?<year>\\d{4})(?<month>\\d{2})(?<day>\\d{2})$");
        DateParserBuilder.register("^(?<year>\\d{4})(?<month>\\d{2})(?<day>\\d{2})(?<hour>\\d{2})(?<minute>\\d{2})(?<second>\\d{2})$");
        DateParserBuilder.register("^(?<unixsecond>\\d{10})$");
        DateParserBuilder.register("^(?<millisecond>\\d{11,13})$");
        DateParserBuilder.register("^(?<microsecond>\\d{16})$");
        DateParserBuilder.register("^(?<nanosecond>\\d{19})$");
        DateParserBuilder.register("\\W*(?:at )?(?<hour>\\d{1,2}):(?<minute>\\d{1,2})(?::(?<second>\\d{1,2}))?(?:[.,](?<ns>\\d{1,9}))?(?<zero>z)?");
        DateParserBuilder.register(" ?(?<zoneOffset>[-+]\\d{1,2}:?(?:\\d{2})?)");
        DateParserBuilder.register(" ?(?<hour>\\d{1,2}) o\u2019clock\\W*");
        DateParserBuilder.register(" ?(?<m>am|pm)\\W*");
        DateParserBuilder.register(" [(](?<zoneName>.+)[)]");
        for (String zoneId : TimeZone.getAvailableIDs()) {
            TimeZone zone = TimeZone.getTimeZone(zoneId);
            RuleHandler handler = (cs, matcher, dt) -> {
                dt.zone = zone;
            };
            String zoneIdStr = zone.getID().toLowerCase();
            DateParserBuilder.register(String.format(" ?\\Q%s\\E", zoneIdStr), handler);
            DateParserBuilder.register(String.format(" ?\\Q[%s]\\E", zoneIdStr), handler);
        }
        DateParserBuilder.register(" ?pdt", (cs, matcher, dt) -> {
            dt.zone = TimeZone.getTimeZone("PST");
        });
        DateParserBuilder.register(" ?cest", (cs, matcher, dt) -> {
            dt.zone = TimeZone.getTimeZone("CET");
        });
        DateParserBuilder.register(" msk m=[+-]\\d\\.\\d+");
    }
}

