/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.wagon;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.kuali.maven.wagon.PutFileContext;
import org.kuali.maven.wagon.SessionListenerSupport;
import org.kuali.maven.wagon.TransferListenerSupport;
import org.kuali.maven.wagon.TransferProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWagon
implements Wagon {
    private static final Logger log = LoggerFactory.getLogger(AbstractWagon.class);
    private int timeout;
    private boolean interactive;
    private Repository repository;
    private final boolean supportsDirectoryCopy;
    private final SessionListenerSupport sessionListeners = new SessionListenerSupport(this);
    private final TransferListenerSupport transferListeners = new TransferListenerSupport(this);

    protected AbstractWagon(boolean supportsDirectoryCopy) {
        this.supportsDirectoryCopy = supportsDirectoryCopy;
    }

    public final void addSessionListener(SessionListener listener) {
        if (listener.getClass().equals(Debug.class)) {
            return;
        }
        this.sessionListeners.addListener(listener);
    }

    protected final SessionListenerSupport getSessionListeners() {
        return this.sessionListeners;
    }

    public final boolean hasSessionListener(SessionListener listener) {
        return this.sessionListeners.hasListener(listener);
    }

    public final void removeSessionListener(SessionListener listener) {
        this.sessionListeners.removeListener(listener);
    }

    public final void addTransferListener(TransferListener listener) {
        this.transferListeners.addListener(listener);
    }

    protected final TransferListenerSupport getTransferListeners() {
        return this.transferListeners;
    }

    public final boolean hasTransferListener(TransferListener listener) {
        return this.transferListeners.hasListener(listener);
    }

    public final void removeTransferListener(TransferListener listener) {
        this.transferListeners.removeListener(listener);
    }

    public final Repository getRepository() {
        return this.repository;
    }

    public final boolean isInteractive() {
        return this.interactive;
    }

    public final void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public final void connect(Repository source) throws ConnectionException, AuthenticationException {
        this.doConnect(source, null, null);
    }

    public final void connect(Repository source, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(source, null, proxyInfo);
    }

    public final void connect(Repository source, AuthenticationInfo authenticationInfo) throws ConnectionException, AuthenticationException {
        this.doConnect(source, authenticationInfo, null);
    }

    protected void doConnect(Repository source, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.repository = source;
        log.debug("Connecting to " + this.repository.getUrl());
        this.sessionListeners.fireSessionOpening();
        try {
            this.connectToRepository(source, authenticationInfo, proxyInfo);
        }
        catch (ConnectionException e) {
            this.sessionListeners.fireSessionConnectionRefused();
            throw e;
        }
        catch (AuthenticationException e) {
            this.sessionListeners.fireSessionConnectionRefused();
            throw e;
        }
        catch (Exception e) {
            this.sessionListeners.fireSessionConnectionRefused();
            throw new ConnectionException("Could not connect to repository", (Throwable)e);
        }
        this.sessionListeners.fireSessionLoggedIn();
        this.sessionListeners.fireSessionOpened();
    }

    public final void connect(Repository source, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.doConnect(source, authenticationInfo, proxyInfo);
    }

    public final void disconnect() throws ConnectionException {
        this.sessionListeners.fireSessionDisconnecting();
        try {
            this.disconnectFromRepository();
        }
        catch (ConnectionException e) {
            this.sessionListeners.fireSessionConnectionRefused();
            throw e;
        }
        catch (Exception e) {
            this.sessionListeners.fireSessionConnectionRefused();
            throw new ConnectionException("Could not disconnect from repository", (Throwable)e);
        }
        this.sessionListeners.fireSessionLoggedOff();
        this.sessionListeners.fireSessionDisconnected();
    }

    public final void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.transferListeners.fireTransferInitiated(resource, 5);
        this.transferListeners.fireTransferStarted(resource, 5);
        try {
            this.getResource(resourceName, destination, new TransferProgress(resource, 5, this.transferListeners));
            this.transferListeners.fireTransferCompleted(resource, 5);
        }
        catch (TransferFailedException e) {
            throw e;
        }
        catch (ResourceDoesNotExistException e) {
            throw e;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            this.transferListeners.fireTransferError(resource, 5, e);
            throw new TransferFailedException("Transfer of resource " + destination + "failed", (Throwable)e);
        }
    }

    public final List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            return this.listDirectory(destinationDirectory);
        }
        catch (TransferFailedException e) {
            throw e;
        }
        catch (ResourceDoesNotExistException e) {
            throw e;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            this.sessionListeners.fireSessionError(e);
            throw new TransferFailedException("Listing of directory " + destinationDirectory + "failed", (Throwable)e);
        }
    }

    public final boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        try {
            if (this.isRemoteResourceNewer(resourceName, timestamp)) {
                this.get(resourceName, destination);
                return true;
            }
            return false;
        }
        catch (TransferFailedException e) {
            throw e;
        }
        catch (ResourceDoesNotExistException e) {
            throw e;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            this.transferListeners.fireTransferError(resource, 5, e);
            throw new TransferFailedException("Transfer of resource " + destination + "failed", (Throwable)e);
        }
    }

    @Deprecated
    public final void openConnection() throws ConnectionException, AuthenticationException {
    }

    protected PutFileContext getPutFileContext(File source, String destination) {
        Resource resource = new Resource(destination);
        PutFileContext context = new PutFileContext();
        context.setResource(resource);
        context.setProgress(new TransferProgress(resource, 6, this.transferListeners));
        context.setListeners(this.transferListeners);
        context.setDestination(destination);
        context.setSource(source);
        return context;
    }

    public final void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        PutFileContext context = this.getPutFileContext(source, destination);
        try {
            context.fireStart();
            this.putResource(source, destination, context.getProgress());
            context.fireComplete();
        }
        catch (Exception e) {
            this.handleException(e, context);
        }
    }

    protected void handleException(Exception e, PutFileContext context) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (e instanceof TransferFailedException) {
            throw (TransferFailedException)((Object)e);
        }
        if (e instanceof ResourceDoesNotExistException) {
            throw (ResourceDoesNotExistException)((Object)e);
        }
        if (e instanceof AuthorizationException) {
            throw (AuthorizationException)((Object)e);
        }
        this.transferListeners.fireTransferError(context.getResource(), 6, e);
        throw new TransferFailedException("Transfer of resource " + context.getDestination() + "failed", (Throwable)e);
    }

    protected List<PutFileContext> getPutFileContexts(File sourceDirectory, String destinationDirectory) {
        ArrayList<PutFileContext> contexts = new ArrayList<PutFileContext>();
        for (File f : sourceDirectory.listFiles()) {
            if (f.isDirectory()) {
                contexts.addAll(this.getPutFileContexts(f, destinationDirectory + "/" + f.getName()));
                continue;
            }
            PutFileContext context = this.getPutFileContext(f, destinationDirectory + "/" + f.getName());
            contexts.add(context);
        }
        return contexts;
    }

    public final boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            return this.doesRemoteResourceExist(resourceName);
        }
        catch (TransferFailedException e) {
            throw e;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            this.sessionListeners.fireSessionError(e);
            throw new TransferFailedException("Listing of resource " + resourceName + "failed", (Throwable)e);
        }
    }

    public final boolean supportsDirectoryCopy() {
        return this.supportsDirectoryCopy;
    }

    protected abstract void connectToRepository(Repository var1, AuthenticationInfo var2, ProxyInfo var3) throws Exception;

    protected abstract boolean doesRemoteResourceExist(String var1) throws Exception;

    protected abstract void disconnectFromRepository() throws Exception;

    protected abstract void getResource(String var1, File var2, TransferProgress var3) throws Exception;

    protected abstract boolean isRemoteResourceNewer(String var1, long var2) throws Exception;

    protected abstract List<String> listDirectory(String var1) throws Exception;

    protected abstract void putResource(File var1, String var2, TransferProgress var3) throws Exception;

    public void connect(Repository source, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.doConnect(source, authenticationInfo, null);
    }

    public void connect(Repository source, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.doConnect(source, null, null);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeoutValue) {
        this.timeout = timeoutValue;
    }
}

