/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

public class RealFFTUtils_3D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private final int columns;
    private final int rows;
    private final int rowStride;
    private final int slices;
    private final int sliceStride;

    public RealFFTUtils_3D(int slices, int rows, int columns) {
        this.slices = slices;
        this.rows = rows;
        this.columns = columns;
        this.rowStride = columns;
        this.sliceStride = rows * this.rowStride;
    }

    public int getIndex(int s, int r, int c) {
        int rr;
        int cmod2 = c & 1;
        int rmul2 = r << 1;
        int smul2 = s << 1;
        int ss = s == 0 ? 0 : this.slices - s;
        int n = rr = r == 0 ? 0 : this.rows - r;
        if (c <= 1) {
            if (r == 0) {
                if (s == 0) {
                    return c == 0 ? 0 : Integer.MIN_VALUE;
                }
                if (smul2 < this.slices) {
                    return s * this.sliceStride + c;
                }
                if (smul2 > this.slices) {
                    int index = ss * this.sliceStride;
                    return cmod2 == 0 ? index : -(index + 1);
                }
                return cmod2 == 0 ? s * this.sliceStride : Integer.MIN_VALUE;
            }
            if (rmul2 < this.rows) {
                return s * this.sliceStride + r * this.rowStride + c;
            }
            if (rmul2 > this.rows) {
                int index = ss * this.sliceStride + rr * this.rowStride;
                return cmod2 == 0 ? index : -(index + 1);
            }
            if (s == 0) {
                return cmod2 == 0 ? r * this.rowStride : Integer.MIN_VALUE;
            }
            if (smul2 < this.slices) {
                return s * this.sliceStride + r * this.rowStride + c;
            }
            if (smul2 > this.slices) {
                int index = ss * this.sliceStride + r * this.rowStride;
                return cmod2 == 0 ? index : -(index + 1);
            }
            int index = s * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index : Integer.MIN_VALUE;
        }
        if (c < this.columns) {
            return s * this.sliceStride + r * this.rowStride + c;
        }
        if (c > this.columns + 1) {
            int cc = (this.columns << 1) - c;
            int index = ss * this.sliceStride + rr * this.rowStride + cc;
            return cmod2 == 0 ? index : -(index + 2);
        }
        if (r == 0) {
            if (s == 0) {
                return cmod2 == 0 ? 1 : Integer.MIN_VALUE;
            }
            if (smul2 < this.slices) {
                int index = ss * this.sliceStride;
                return cmod2 == 0 ? index + 1 : -index;
            }
            if (smul2 > this.slices) {
                int index = s * this.sliceStride;
                return cmod2 == 0 ? index + 1 : index;
            }
            int index = s * this.sliceStride;
            return cmod2 == 0 ? index + 1 : Integer.MIN_VALUE;
        }
        if (rmul2 < this.rows) {
            int index = ss * this.sliceStride + rr * this.rowStride;
            return cmod2 == 0 ? index + 1 : -index;
        }
        if (rmul2 > this.rows) {
            int index = s * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index + 1 : index;
        }
        if (s == 0) {
            int index = r * this.rowStride + 1;
            return cmod2 == 0 ? index : Integer.MIN_VALUE;
        }
        if (smul2 < this.slices) {
            int index = ss * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index + 1 : -index;
        }
        if (smul2 > this.slices) {
            int index = s * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index + 1 : index;
        }
        int index = s * this.sliceStride + r * this.rowStride;
        return cmod2 == 0 ? index + 1 : Integer.MIN_VALUE;
    }

    public void pack(double val, int s, int r, int c, double[] packed, int pos) {
        int i = this.getIndex(s, r, c);
        if (i >= 0) {
            packed[pos + i] = val;
        } else if (i > Integer.MIN_VALUE) {
            packed[pos - i] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s, r, c));
        }
    }

    public void pack(double val, int s, int r, int c, double[][][] packed) {
        int i = this.getIndex(s, r, c);
        int ii = Math.abs(i);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i >= 0) {
            packed[ss][rr][cc] = val;
        } else if (i > Integer.MIN_VALUE) {
            packed[ss][rr][cc] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public void pack(float val, int s, int r, int c, float[] packed, int pos) {
        int i = this.getIndex(s, r, c);
        if (i >= 0) {
            packed[pos + i] = val;
        } else if (i > Integer.MIN_VALUE) {
            packed[pos - i] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s, r, c));
        }
    }

    public void pack(float val, int s, int r, int c, float[][][] packed) {
        int i = this.getIndex(s, r, c);
        int ii = Math.abs(i);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i >= 0) {
            packed[ss][rr][cc] = val;
        } else if (i > Integer.MIN_VALUE) {
            packed[ss][rr][cc] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s, r, c));
        }
    }

    public double unpack(int s, int r, int c, double[] packed, int pos) {
        int i = this.getIndex(s, r, c);
        if (i >= 0) {
            return packed[pos + i];
        }
        if (i > Integer.MIN_VALUE) {
            return -packed[pos - i];
        }
        return 0.0;
    }

    public double unpack(int s, int r, int c, double[][][] packed) {
        int i = this.getIndex(s, r, c);
        int ii = Math.abs(i);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i >= 0) {
            return packed[ss][rr][cc];
        }
        if (i > Integer.MIN_VALUE) {
            return -packed[ss][rr][cc];
        }
        return 0.0;
    }

    public float unpack(int s, int r, int c, float[] packed, int pos) {
        int i = this.getIndex(s, r, c);
        if (i >= 0) {
            return packed[pos + i];
        }
        if (i > Integer.MIN_VALUE) {
            return -packed[pos - i];
        }
        return 0.0f;
    }

    public float unpack(int s, int r, int c, float[][][] packed) {
        int i = this.getIndex(s, r, c);
        int ii = Math.abs(i);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i >= 0) {
            return packed[ss][rr][cc];
        }
        if (i > Integer.MIN_VALUE) {
            return -packed[ss][rr][cc];
        }
        return 0.0f;
    }
}

