/*
 * Decompiled with CFR 0.152.
 */
package com.github.rtyley.android.screenshot.paparazzo.processors;

import com.github.rtyley.android.screenshot.paparazzo.processors.ScreenshotProcessor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageSaver
implements ScreenshotProcessor {
    private final File screenshotDirectory;
    private int screenshotCount = 0;

    public ImageSaver(File screenshotDirectory) {
        this.screenshotDirectory = screenshotDirectory;
    }

    @Override
    public void process(BufferedImage image, Map<String, String> request) {
        String name = request.containsKey("name") ? request.get("name") : String.format("%04d", this.screenshotCount++);
        File screenshotFile = new File(this.screenshotDirectory, name + ".png");
        try {
            ImageIO.write((RenderedImage)image, "png", screenshotFile);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public void finish() {
    }
}

