/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.servlet.servlet.internal;

import com.github.rmannibucau.playx.servlet.servlet.internal.OutputStreamAdapter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.pekko.util.ByteString;
import play.http.HttpEntity;
import play.mvc.Result;

public class ResponseAdapter
implements HttpServletResponse {
    private final String requestUri;
    private final Collection<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final ServletContext context;
    private int status = 200;
    private boolean commited;
    private String encoding;
    private int bufferSize = 8192;
    private Locale locale;
    private OutputStreamAdapter outputStream;
    private PrintWriter writer;
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    private final CompletableFuture<Result> completion = new CompletableFuture();

    public ResponseAdapter(String requestUri, ServletContext context) {
        this.requestUri = requestUri;
        this.context = context;
    }

    public CompletionStage<Result> toResult() {
        return this.completion;
    }

    public void fail(Throwable error) {
        if (this.completion.isDone()) {
            return;
        }
        try {
            this.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.completion.completeExceptionally(error);
    }

    public void onComplete() {
        if (this.completion.isDone()) {
            return;
        }
        try {
            this.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String contentType = this.headers.remove("Content-Type");
        this.headers.remove("Content-Length");
        this.completion.complete(new Result(this.status, this.headers, (HttpEntity)new HttpEntity.Strict(ByteString.fromArray((byte[])this.output.toByteArray()), Optional.ofNullable(contentType))));
    }

    private String base() {
        URI uri = URI.create(this.requestUri);
        return uri.getScheme() + "://" + uri.getAuthority();
    }

    private String toEncoded(String url) {
        return url;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeURL(String s) {
        return this.toEncoded(s);
    }

    public String encodeRedirectURL(String s) {
        return this.toEncoded(s);
    }

    public String encodeUrl(String s) {
        return this.toEncoded(s);
    }

    public String encodeRedirectUrl(String s) {
        return this.encodeRedirectURL(s);
    }

    public void sendError(int sc, String msg) {
        this.sendError(sc);
    }

    public void sendError(int sc) {
        this.setStatus(sc);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.commited) {
            throw new IllegalStateException("response already committed");
        }
        this.resetBuffer();
        try {
            this.setStatus(302);
            this.setHeader("Location", this.base() + this.toEncoded(location));
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
    }

    public void setDateHeader(String name, long date) {
        this.addDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.setHeader(name, Long.toString(date));
    }

    public void setHeader(String name, String value) {
        this.addHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.addIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.headers.put(name, Integer.toString(value));
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public void setStatus(int sc, String sm) {
        this.setStatus(sc);
    }

    public int getStatus() {
        return this.status;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Collection<String> getHeaders(String name) {
        return Optional.ofNullable(this.headers.get(name)).map(Collections::singleton).orElseGet(Collections::emptySet);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String getCharacterEncoding() {
        return Optional.ofNullable(this.encoding).orElseGet(() -> ((ServletContext)this.context).getResponseCharacterEncoding());
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletOutputStream getOutputStream() {
        return this.outputStream == null ? (this.outputStream = new OutputStreamAdapter(this.output)) : this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer == null ? (this.writer = new PrintWriter((OutputStream)this.getOutputStream())) : this.writer;
    }

    public void setCharacterEncoding(String charset) {
        this.encoding = charset;
    }

    public void setContentLength(int len) {
        this.setHeader("Content-Length", Integer.toString(len));
    }

    public void setContentLengthLong(long length) {
        this.setHeader("Content-Length", Long.toString(length));
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public void setBufferSize(int size) {
        if (this.outputStream == null && this.writer == null) {
            this.output = new ByteArrayOutputStream(size);
            this.bufferSize = size;
        }
    }

    public int getBufferSize() {
        return this.output.size();
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.output.flush();
    }

    public void resetBuffer() {
        this.output.reset();
    }

    public boolean isCommitted() {
        return this.commited;
    }

    public void reset() {
        this.output.reset();
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

