/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.servlet.servlet.internal;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

class OutputStreamAdapter
extends ServletOutputStream {
    private final OutputStream delegate;
    private WriteListener listener;

    OutputStreamAdapter(OutputStream output) {
        this.delegate = output;
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener listener) {
        this.listener = listener;
        try {
            listener.onWritePossible();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void write(int b) throws IOException {
        try {
            this.delegate.write(b);
        }
        catch (IOException ioe) {
            this.listener.onError((Throwable)ioe);
            throw ioe;
        }
    }

    public void write(byte[] b) throws IOException {
        try {
            this.delegate.write(b);
        }
        catch (IOException ioe) {
            this.listener.onError((Throwable)ioe);
            throw ioe;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.delegate.write(b, off, len);
        }
        catch (IOException ioe) {
            this.listener.onError((Throwable)ioe);
            throw ioe;
        }
    }

    public void flush() throws IOException {
        try {
            this.delegate.flush();
        }
        catch (IOException ioe) {
            this.listener.onError((Throwable)ioe);
            throw ioe;
        }
    }

    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        catch (IOException ioe) {
            this.listener.onError((Throwable)ioe);
            throw ioe;
        }
    }
}

