/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.servlet.servlet.internal;

import com.github.rmannibucau.playx.servlet.servlet.api.PlayServletContext;
import com.github.rmannibucau.playx.servlet.servlet.internal.DynamicServlet;
import com.github.rmannibucau.playx.servlet.servlet.internal.ResponseAdapter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.inject.Injector;

public class AsyncContextImpl
implements AsyncContext {
    public static final Logger LOGGER = LoggerFactory.getLogger(AsyncContextImpl.class);
    private final ServletRequest request;
    private final ServletResponse response;
    private final ResponseAdapter rootResponse;
    private final boolean originalRequestAndResponse;
    private final Injector injector;
    private final Collection<AsyncListener> listeners = new ArrayList<AsyncListener>();
    private final DynamicServlet servlet;
    private long timeout;

    AsyncContextImpl(ServletRequest servletRequest, ResponseAdapter rootResponse, ServletResponse servletResponse, boolean originalRequestAndResponse, Injector injector, DynamicServlet servlet) {
        this.request = servletRequest;
        this.rootResponse = rootResponse;
        this.response = servletResponse;
        this.originalRequestAndResponse = originalRequestAndResponse;
        this.injector = injector;
        this.servlet = servlet;
    }

    AsyncContext start() {
        AsyncEvent event = new AsyncEvent((AsyncContext)this, this.request, this.response);
        this.executeOnListeners(l -> l.onStartAsync(event), this.listeners::clear);
        return this;
    }

    public void onError(Throwable throwable) {
        AsyncEvent event = new AsyncEvent((AsyncContext)this, this.request, this.response, throwable);
        this.executeOnListeners(l -> l.onError(event), null);
        if (!this.response.isCommitted() && HttpServletResponse.class.isInstance(this.response)) {
            HttpServletResponse http = (HttpServletResponse)HttpServletResponse.class.cast(this.response);
            http.setStatus(500);
        }
        this.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOnListeners(UnsafeConsumer<AsyncListener> fn, Runnable afterCopy) {
        ArrayList listenersCopy;
        Collection<AsyncListener> collection = this.listeners;
        synchronized (collection) {
            listenersCopy = new ArrayList(this.listeners.size());
            Optional.ofNullable(afterCopy).ifPresent(Runnable::run);
        }
        listenersCopy.forEach(listener -> {
            try {
                fn.accept((AsyncListener)listener);
            }
            catch (Throwable t) {
                LOGGER.warn("callback failed for listener of type [" + listener.getClass().getName() + "]", t);
            }
        });
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.originalRequestAndResponse;
    }

    public void dispatch() {
        ServletRequest servletRequest = this.getRequest();
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            throw new IllegalStateException("Not a http request: " + servletRequest);
        }
        HttpServletRequest sr = (HttpServletRequest)HttpServletRequest.class.cast(servletRequest);
        String path = sr.getRequestURI();
        String cpath = sr.getContextPath();
        if (cpath.length() > 1) {
            path = path.substring(cpath.length());
        }
        this.dispatch(AsyncContextImpl.urlDecode(path, StandardCharsets.UTF_8));
    }

    public void dispatch(String path) {
        this.dispatch(this.request.getServletContext(), path);
    }

    public void dispatch(ServletContext context, String path) {
        ServletRequest servletRequest = this.getRequest();
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            throw new IllegalStateException("Not a http request: " + servletRequest);
        }
        HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(servletRequest);
        if (request.getAttribute("javax.servlet.async.request_uri") == null) {
            request.setAttribute("javax.servlet.async.request_uri", (Object)request.getRequestURI());
            request.setAttribute("javax.servlet.async.context_path", (Object)request.getContextPath());
            request.setAttribute("javax.servlet.async.servlet_path", (Object)request.getServletPath());
            request.setAttribute("javax.servlet.async.path_info", (Object)request.getPathInfo());
            request.setAttribute("javax.servlet.async.query_string", (Object)request.getQueryString());
        }
        try {
            this.servlet.getInstance().service((ServletRequest)request, this.response);
        }
        catch (IOException | ServletException ioe) {
            this.onError(ioe);
        }
    }

    public void complete() {
        AsyncEvent event = new AsyncEvent((AsyncContext)this, this.request, this.response);
        this.executeOnListeners(l -> l.onComplete(event), null);
        this.rootResponse.onComplete();
    }

    public void start(Runnable run) {
        if (PlayServletContext.class.isInstance(this.getRequest().getServletContext())) {
            PlayServletContext context = (PlayServletContext)PlayServletContext.class.cast(this.getRequest().getServletContext());
            context.getDefaultExecutor().execute(run);
        } else {
            run.run();
        }
    }

    public void addListener(AsyncListener listener) {
        this.listeners.add(new AsyncListenerWrapper(listener, this.request, this.response));
    }

    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        this.listeners.add(new AsyncListenerWrapper(listener, request, response));
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) {
        return (T)((AsyncListener)this.injector.instanceOf(clazz));
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    private static String urlDecode(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(37) == -1) {
            return str;
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(str.length() * 2);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, charset);
        char[] sourceChars = str.toCharArray();
        int len = sourceChars.length;
        int ix = 0;
        try {
            while (ix < len) {
                char c;
                if ((c = sourceChars[ix++]) == '%') {
                    osw.flush();
                    if (ix + 2 > len) {
                        throw new IllegalArgumentException("Missing digit: " + str);
                    }
                    char c1 = sourceChars[ix++];
                    char c2 = sourceChars[ix++];
                    if (AsyncContextImpl.isHexDigit(c1) && AsyncContextImpl.isHexDigit(c2)) {
                        baos.write(AsyncContextImpl.x2c(c1, c2));
                        continue;
                    }
                    throw new IllegalArgumentException("Missing digit: " + str);
                }
                osw.append(c);
            }
            osw.flush();
            return baos.toString(charset.name());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    private static boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private static int x2c(char b1, char b2) {
        int digit = b1 >= 'A' ? (b1 & 0xDF) - 65 + 10 : b1 - 48;
        digit *= 16;
        return digit += b2 >= 'A' ? (b2 & 0xDF) - 65 + 10 : b2 - 48;
    }

    @FunctionalInterface
    private static interface UnsafeConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    private static class AsyncListenerWrapper
    implements AsyncListener {
        private final AsyncListener delegate;
        private final ServletRequest request;
        private final ServletResponse response;

        private AsyncListenerWrapper(AsyncListener delegate, ServletRequest request, ServletResponse response) {
            this.delegate = delegate;
            this.request = request;
            this.response = response;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            this.delegate.onComplete(this.wrap(event));
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this.delegate.onTimeout(this.wrap(event));
        }

        public void onError(AsyncEvent event) throws IOException {
            this.delegate.onError(this.wrap(event));
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            this.delegate.onStartAsync(this.wrap(event));
        }

        private AsyncEvent wrap(AsyncEvent event) {
            if (this.request != null && this.response != null) {
                return new AsyncEvent(event.getAsyncContext(), this.request, this.response, event.getThrowable());
            }
            return event;
        }
    }
}

