/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.servlet.servlet.api;

import com.github.rmannibucau.playx.servlet.servlet.api.PlayServletContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.pekko.util.ByteString;
import play.http.HttpErrorHandler;
import play.inject.Injector;
import play.libs.streams.Accumulator;
import play.mvc.BodyParser;
import play.mvc.EssentialAction;
import play.mvc.EssentialFilter;
import play.mvc.Http;
import play.mvc.Result;

@Singleton
public class ServletFilter
extends EssentialFilter
implements Consumer<ServletFilter> {
    private Injector injector;
    private final State state = new State();

    @Inject
    public ServletFilter(Injector injector) {
        this.injector = injector;
    }

    public EssentialAction apply(final EssentialAction next) {
        this.state.ensureInit(this.injector);
        return new EssentialAction(){

            public Accumulator<ByteString, Result> apply(Http.RequestHeader requestHeader) {
                return ServletFilter.this.state.getServletContext().findMatchingServlet(requestHeader).map(servlet -> {
                    long length = requestHeader.getHeaders().get("Content-Length").map(Long::parseLong).orElse(Long.MAX_VALUE);
                    BodyParser.Bytes slurper = new BodyParser.Bytes(length, ServletFilter.this.state.getHttpErrorHandler());
                    return slurper.apply(requestHeader).mapFuture(resultOrBytes -> resultOrBytes.left.map(CompletableFuture::completedFuture).orElseGet(() -> ServletFilter.this.state.getServletContext().executeInvoke((PlayServletContext.ServletMatching)servlet, requestHeader, ((ByteString)resultOrBytes.right.get()).iterator().asInputStream(), servlet.getServletPath()).toCompletableFuture()), ServletFilter.this.state.getServletContext().getDefaultExecutor());
                }).orElseGet(() -> next.apply(requestHeader));
            }
        };
    }

    @Override
    public void accept(ServletFilter actual) {
        this.state.ensureInit(actual.getInjector());
    }

    Injector getInjector() {
        return this.injector;
    }

    @Singleton
    public static class State {
        @Inject
        private PlayServletContext servletContext;
        @Inject
        private HttpErrorHandler httpErrorHandler;
        private volatile boolean init = false;

        public PlayServletContext getServletContext() {
            return this.servletContext;
        }

        public HttpErrorHandler getHttpErrorHandler() {
            return this.httpErrorHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ensureInit(Injector injector) {
            if (!this.init) {
                State state = this;
                synchronized (state) {
                    if (!this.init) {
                        this.servletContext = (PlayServletContext)injector.instanceOf(PlayServletContext.class);
                        this.httpErrorHandler = (HttpErrorHandler)injector.instanceOf(HttpErrorHandler.class);
                    }
                    this.init = true;
                }
            }
        }
    }
}

