/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.servlet.servlet.internal;

import com.github.rmannibucau.playx.servlet.servlet.api.PlayServletContext;
import com.github.rmannibucau.playx.servlet.servlet.internal.DynamicServlet;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class RequestDispatcherImpl
implements RequestDispatcher {
    private final PlayServletContext context;
    private final String path;

    public RequestDispatcherImpl(PlayServletContext context, String path) {
        this.context = context;
        this.path = path;
    }

    private void doExecute(ServletRequest request, ServletResponse response) {
        this.context.getDefaultExecutor().execute(() -> {
            DynamicServlet dynamicServlet = this.context.findFirstMatchingServlet(this.path).orElseThrow(() -> new IllegalArgumentException("No matching servlet for path '" + this.path + "'")).getDynamicServlet();
            try {
                dynamicServlet.getInstance().service(request, response);
            }
            catch (IOException | ServletException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public void forward(ServletRequest request, ServletResponse response) {
        this.doExecute(request, response);
    }

    public void include(ServletRequest request, ServletResponse response) {
        this.doExecute(request, response);
    }
}

