/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.servlet.servlet.internal;

import com.github.rmannibucau.playx.servlet.servlet.internal.AsyncContextImpl;
import com.github.rmannibucau.playx.servlet.servlet.internal.DynamicServlet;
import com.github.rmannibucau.playx.servlet.servlet.internal.InputStreamAdapter;
import com.github.rmannibucau.playx.servlet.servlet.internal.ResponseAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import play.api.i18n.Lang;
import play.api.inject.Injector;
import play.libs.typedmap.TypedKey;
import play.mvc.Http;

public class RequestAdapter
implements HttpServletRequest {
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final DateFormat[] DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    private final Supplier<DateFormat[]> dateFormats;
    private final Http.RequestHeader playDelegate;
    private final InputStream entity;
    private final ServletResponse response;
    private final Injector injector;
    private final ServletContext context;
    private final DynamicServlet servlet;
    private final String servletPath;
    private final String facingServletPath;
    private ServletInputStream inputStream;
    private BufferedReader reader;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean asyncStarted;
    private Map<String, String> params;

    public RequestAdapter(Http.RequestHeader request, InputStream entity, ServletResponse response, Injector injector, ServletContext context, DynamicServlet servlet, String servletPath) {
        this.context = context;
        this.playDelegate = request;
        this.entity = entity;
        this.response = response;
        this.injector = injector;
        this.servlet = servlet;
        this.servletPath = servletPath;
        this.facingServletPath = servletPath.endsWith("/") ? servletPath.substring(0, servletPath.length() - 1) : servletPath;
        this.dateFormats = new Supplier<DateFormat[]>(){
            private DateFormat[] formats;

            @Override
            public DateFormat[] get() {
                if (this.formats == null) {
                    this.formats = (DateFormat[])Stream.of(DATE_FORMATS).map(DateFormat::clone).map(DateFormat.class::cast).toArray(DateFormat[]::new);
                }
                return this.formats;
            }
        };
        this.parseParams();
    }

    public Cookie[] getCookies() {
        return (Cookie[])StreamSupport.stream(this.playDelegate.cookies().spliterator(), false).map(c -> new Cookie(c.name(), c.value())).toArray(Cookie[]::new);
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = this.parseDate(value);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        List option = this.playDelegate.getHeaders().getAll(name);
        return option != null && !option.isEmpty() ? (String)option.iterator().next() : null;
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.playDelegate.getHeaders().getAll(name));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.playDelegate.getHeaders().toMap().keySet());
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.playDelegate.method();
    }

    public String getQueryString() {
        String uri = this.playDelegate.uri();
        int questionMark = uri.indexOf(63);
        return questionMark >= 0 ? uri.substring(questionMark + 1) : "";
    }

    public String getPathInfo() {
        if ("/".equals(this.servletPath)) {
            return null;
        }
        String servletUri = this.getRequestURI().substring(this.getContextPath().length());
        if (servletUri.startsWith(this.servletPath)) {
            return servletUri.substring(this.servletPath.endsWith("/") ? this.servletPath.length() - 1 : this.servletPath.length());
        }
        return null;
    }

    public String getPathTranslated() {
        return "/";
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public String getAuthType() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        String uri = this.playDelegate.uri();
        String queryString = this.getQueryString();
        return uri.substring(0, uri.length() - queryString.length() - (queryString.isEmpty() ? 0 : 1));
    }

    public StringBuffer getRequestURL() {
        StringBuffer base = new StringBuffer(this.getScheme()).append("://").append(this.getServerName());
        int serverPort = this.getServerPort();
        if (serverPort != 80 && serverPort != 443) {
            base.append(':').append(serverPort);
        }
        return base.append(this.getRequestURI());
    }

    public String getServletPath() {
        return this.facingServletPath;
    }

    public HttpSession getSession(boolean create) {
        return null;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) {
        return false;
    }

    public void login(String username, String password) throws ServletException {
        throw new ServletException("Unsupported");
    }

    public void logout() throws ServletException {
        throw new ServletException("Unsupported");
    }

    public Collection<Part> getParts() {
        return Collections.emptyList();
    }

    public Part getPart(String name) {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws ServletException {
        throw new ServletException("Unsupported");
    }

    public Object getAttribute(String name) {
        return Optional.ofNullable(this.attributes.get(name)).orElseGet(() -> this.playDelegate.attrs().getOptional(TypedKey.create((String)name)).orElse(null));
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.playDelegate.charset().orElseGet(() -> Optional.ofNullable(RequestAdapter.getCharsetFromContentType(this.getContentType())).orElse(this.getServletContext().getRequestCharacterEncoding()));
    }

    public void setCharacterEncoding(String env) {
        throw new UnsupportedOperationException();
    }

    public int getContentLength() {
        return (int)this.getContentLengthLong();
    }

    public long getContentLengthLong() {
        return Optional.ofNullable(this.getHeader("content-length")).map(Long::parseLong).orElse(-1L);
    }

    public String getContentType() {
        return this.playDelegate.contentType().orElse(null);
    }

    public ServletInputStream getInputStream() {
        return this.inputStream == null ? (this.inputStream = new InputStreamAdapter(this.entity)) : this.inputStream;
    }

    public BufferedReader getReader() throws IOException {
        return this.reader == null ? (this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()))) : this.reader;
    }

    public String getParameter(String name) {
        return Optional.ofNullable(this.playDelegate.getQueryString(name)).orElseGet(() -> this.playDelegate.contentType().filter("multipart/form-data"::equalsIgnoreCase).map(ct -> this.params.get(name)).orElse(null));
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(Stream.concat(this.playDelegate.queryString().keySet().stream(), this.playDelegate.contentType().filter("multipart/form-data"::equalsIgnoreCase).map(ct -> this.params.keySet().stream()).orElseGet(Stream::empty)).collect(Collectors.toSet()));
    }

    /*
     * Exception decompiling
     */
    public String[] getParameterValues(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<String, String[]> getParameterMap() {
        Stream query = this.playDelegate.queryString().entrySet().stream();
        Stream form = this.playDelegate.contentType().filter("multipart/form-data"::equalsIgnoreCase).map(ct -> this.params.entrySet().stream().map(v -> new AbstractMap.SimpleEntry(v.getKey(), new String[]{(String)v.getValue()}))).orElseGet(Stream::empty);
        return Stream.concat(query, form).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> first));
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getScheme() {
        return this.playDelegate.secure() ? "https" : "http";
    }

    public String getServerName() {
        String host = this.playDelegate.host();
        int sep = host.indexOf(58);
        return sep < 0 ? host : host.substring(0, sep);
    }

    public int getServerPort() {
        String host = this.playDelegate.host();
        int sep = host.indexOf(58);
        return sep < 0 ? (this.playDelegate.secure() ? 443 : 80) : Integer.parseInt(host.substring(sep + 1));
    }

    public String getRemoteAddr() {
        return this.playDelegate.remoteAddress();
    }

    public String getRemoteHost() {
        String host = this.playDelegate.host();
        return host.contains(":") ? host.substring(0, host.indexOf(58)) : host;
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        Enumeration<Locale> locales = this.getLocales();
        return locales.hasMoreElements() ? locales.nextElement() : null;
    }

    public Enumeration<Locale> getLocales() {
        List langSeq = this.playDelegate.acceptLanguages();
        return Collections.enumeration(langSeq.stream().map(Lang::locale).collect(Collectors.toSet()));
    }

    public boolean isSecure() {
        return this.playDelegate.secure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public int getRemotePort() {
        String host = this.playDelegate.host();
        return host.contains(":") ? Integer.parseInt(host.substring(host.indexOf(58) + 1)) : (this.isSecure() ? 443 : 80);
    }

    public String getLocalName() {
        return "127.0.0.1";
    }

    public String getLocalAddr() {
        return "127.0.0.1";
    }

    public int getLocalPort() {
        return 80;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        this.asyncStarted = true;
        return this.startAsync((ServletRequest)this, this.response);
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        this.asyncStarted = true;
        return new AsyncContextImpl(servletRequest, (ResponseAdapter)ResponseAdapter.class.cast(servletRequest.getAttribute(ResponseAdapter.class.getName())), servletResponse, servletRequest == this, this.injector, this.servlet).start();
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    private void parseParams() {
        if (this.params == null) {
            String contentType;
            this.params = new HashMap<String, String>();
            String method = this.getMethod();
            if (!(method == null || method.equals("GET") || method.equals("DELETE") || method.equals("HEAD") || method.equals("OPTIONS") || (contentType = this.getContentType()) == null || !contentType.contains("application/x-www-form-urlencoded") && !contentType.contains("multipart/form-data"))) {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(this.entity));){
                    StringTokenizer parameters = new StringTokenizer(r.lines().collect(Collectors.joining("\n")), "&");
                    while (parameters.hasMoreTokens()) {
                        StringTokenizer param = new StringTokenizer(parameters.nextToken(), "=");
                        String name = URLDecoder.decode(param.nextToken(), "UTF-8");
                        if (name == null) {
                            break;
                        }
                        String value = param.hasMoreTokens() ? URLDecoder.decode(param.nextToken(), "UTF-8") : "";
                        this.params.put(name, value == null ? "" : value);
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    private long parseDate(String value) {
        for (DateFormat format : this.dateFormats.get()) {
            try {
                return format.parse(value).getTime();
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException(value);
    }

    private static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    /*
     * Exception decompiling
     */
    private /* synthetic */ String[] lambda$getParameterValues$11(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        Stream.of(DATE_FORMATS).forEach(f -> f.setTimeZone(GMT_ZONE));
    }
}

