/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.servlet.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

class InputStreamAdapter
extends ServletInputStream {
    private final InputStream buffer;
    private ReadListener listener;
    private boolean done;

    InputStreamAdapter(InputStream buffer) {
        this.buffer = buffer;
    }

    public boolean isFinished() {
        return true;
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener listener) {
        this.listener = listener;
        if (!this.done) {
            try {
                listener.onDataAvailable();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public int read() throws IOException {
        try {
            int read = this.buffer.read();
            if (read < 0) {
                this.done = true;
                if (this.listener != null) {
                    this.listener.onAllDataRead();
                }
            }
            return read;
        }
        catch (Throwable ioe) {
            if (this.listener != null) {
                this.done = true;
                this.listener.onError(ioe);
            }
            throw ioe;
        }
    }
}

