/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.servlet.servlet.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;

public class DynamicServlet
implements ServletRegistration.Dynamic {
    private final String name;
    private final Servlet instance;
    private int loadOnStartup = -1;
    private final Collection<String> mappings = new HashSet<String>();
    private final Map<String, String> initParameters = new HashMap<String, String>();
    private boolean asyncSupported;

    public DynamicServlet(String name, Servlet servlet) {
        this.name = name;
        this.instance = servlet;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public Servlet getInstance() {
        return this.instance;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        return Collections.emptySet();
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
    }

    public void setRunAsRole(String roleName) {
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        this.asyncSupported = isAsyncSupported;
    }

    public Set<String> addMapping(String ... urlPatterns) {
        this.mappings.addAll(Arrays.asList(urlPatterns));
        return Stream.of(urlPatterns).collect(Collectors.toSet());
    }

    public Collection<String> getMappings() {
        return this.mappings;
    }

    public String getRunAsRole() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.instance.getClass().getName();
    }

    public boolean setInitParameter(String name, String value) {
        this.initParameters.put(name, value);
        return false;
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        this.initParameters.putAll(initParameters);
        return initParameters.keySet();
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public ServletConfig toServletConfig(final ServletContext context) {
        return new ServletConfig(){

            public String getServletName() {
                return DynamicServlet.this.getName();
            }

            public ServletContext getServletContext() {
                return context;
            }

            public String getInitParameter(String name) {
                return (String)DynamicServlet.this.initParameters.get(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(DynamicServlet.this.initParameters.keySet());
            }
        };
    }

    public String toString() {
        return "DynamicServlet(" + this.name + ')';
    }
}

