/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.servlet.servlet.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;

public class DynamicFilter
implements FilterRegistration.Dynamic {
    private final String name;
    private final Filter instance;
    private final Collection<String> mappings = new HashSet<String>();
    private final Collection<String> servletNames = new HashSet<String>();
    private final Map<String, String> initParameters = new HashMap<String, String>();
    private boolean asyncSupported;

    public DynamicFilter(String name, Filter filter) {
        this.name = name;
        this.instance = filter;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public Filter getInstance() {
        return this.instance;
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        this.asyncSupported = isAsyncSupported;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.instance.getClass().getName();
    }

    public boolean setInitParameter(String name, String value) {
        this.initParameters.put(name, value);
        return false;
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        this.initParameters.putAll(initParameters);
        return initParameters.keySet();
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        this.servletNames.addAll(Arrays.asList(servletNames));
    }

    public Collection<String> getServletNameMappings() {
        return this.servletNames;
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        this.mappings.addAll(Arrays.asList(urlPatterns));
    }

    public Collection<String> getUrlPatternMappings() {
        return this.mappings;
    }

    public FilterConfig toFilterConfig(final ServletContext context) {
        return new FilterConfig(){

            public String getFilterName() {
                return DynamicFilter.this.name;
            }

            public ServletContext getServletContext() {
                return context;
            }

            public String getInitParameter(String name) {
                return (String)DynamicFilter.this.initParameters.get(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(DynamicFilter.this.initParameters.keySet());
            }
        };
    }

    public String toString() {
        return "DynamicFilter(" + this.name + ')';
    }
}

