/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.servlet.servlet.api;

import com.github.rmannibucau.playx.servlet.servlet.internal.AsyncContextImpl;
import com.github.rmannibucau.playx.servlet.servlet.internal.DynamicFilter;
import com.github.rmannibucau.playx.servlet.servlet.internal.DynamicServlet;
import com.github.rmannibucau.playx.servlet.servlet.internal.FilterChainImpl;
import com.github.rmannibucau.playx.servlet.servlet.internal.RequestAdapter;
import com.github.rmannibucau.playx.servlet.servlet.internal.RequestDispatcherImpl;
import com.github.rmannibucau.playx.servlet.servlet.internal.ResponseAdapter;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValueType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Environment;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.Injector;
import play.http.HttpEntity;
import play.mvc.Http;
import play.mvc.Result;

@Singleton
public class PlayServletContext
implements ServletContext {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PlayServletContext.class.getName());
    private final Injector injector;
    private final String contextPath;
    private Executor executor;
    private final List<DynamicServlet> servlets = new ArrayList<DynamicServlet>();
    private final List<DynamicFilter> filters = new ArrayList<DynamicFilter>();
    private final Collection<EventListener> listeners = new ArrayList<EventListener>();
    private String requestEncoding = StandardCharsets.ISO_8859_1.name();
    private String responseEncoding = StandardCharsets.ISO_8859_1.name();

    @Inject
    public PlayServletContext(ApplicationLifecycle lifecycle, Injector injector, Config config) {
        this.injector = injector;
        this.contextPath = this.safeConfigAccess(config, "playx.servlet.context", Config::getString).orElse("");
        int core = this.safeConfigAccess(config, "playx.servlet.executor.core", Config::getInt).orElse(64);
        int max = this.safeConfigAccess(config, "playx.servlet.executor.max", Config::getInt).orElse(512);
        int keepAlive = this.safeConfigAccess(config, "playx.servlet.executor.keepAlive.value", Config::getInt).orElse(60);
        TimeUnit keepAliveUnit = this.safeConfigAccess(config, "playx.servlet.executor.keepAlive.unit", (c, k) -> (TimeUnit)c.getEnum(TimeUnit.class, k)).orElse(TimeUnit.SECONDS);
        this.executor = new ThreadPoolExecutor(core, max, (long)keepAlive, keepAliveUnit, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(false);
                thread.setPriority(5);
                thread.setName("playx-servlet-[context=" + PlayServletContext.this.contextPath + "]-" + this.counter.incrementAndGet());
                return thread;
            }
        });
        lifecycle.addStopHook(() -> CompletableFuture.runAsync(() -> ((ExecutorService)ExecutorService.class.cast(this.executor)).shutdownNow(), Runnable::run));
        lifecycle.addStopHook(() -> CompletableFuture.runAsync(this::stop, this.getDefaultExecutor()));
        this.safeConfigAccess(config, "playx.servlet.listeners", Config::getStringList).ifPresent(clazz -> clazz.forEach(init -> {
            ClassLoader classLoader = this.getClassLoader();
            try {
                Class<?> initializer = classLoader.loadClass(init.trim());
                EventListener listener = (EventListener)initializer.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.addListener(listener);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }));
        this.safeConfigAccess(config, "playx.servlet.servlets", Config::getObjectList).ifPresent(servlets -> servlets.forEach(servlet -> {
            Class<?> loadedClass;
            String clazz = Objects.requireNonNull(servlet.get((Object)"className").unwrapped().toString(), "className must be provided: " + servlet);
            String name = Optional.ofNullable(servlet.get((Object)"name")).map(c -> c.unwrapped().toString()).orElse(clazz);
            boolean asyncSupported = this.extractAsyncSupported((ConfigObject)servlet);
            int loadOnStartup = Optional.ofNullable(servlet.get((Object)"loadOnStartup")).filter(c -> c.valueType() == ConfigValueType.NUMBER).map(c -> ((Number)Number.class.cast(c.unwrapped())).intValue()).orElse(0);
            Map<String, String> initParams = this.extractInitParams((ConfigObject)servlet);
            String[] mappings = this.extractMappings((ConfigObject)servlet);
            ClassLoader classLoader = this.getClassLoader();
            try {
                loadedClass = classLoader.loadClass(clazz.trim());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            ServletRegistration.Dynamic dynamic = this.addServlet(name, loadedClass);
            dynamic.setLoadOnStartup(loadOnStartup);
            dynamic.addMapping(mappings);
            initParams.forEach((arg_0, arg_1) -> ((ServletRegistration.Dynamic)dynamic).setInitParameter(arg_0, arg_1));
            if (asyncSupported) {
                dynamic.setAsyncSupported(true);
            } else {
                LOGGER.info("Servlet {} is not set with asyncSupported=true", (Object)name);
            }
        }));
        this.safeConfigAccess(config, "playx.servlet.filters", Config::getObjectList).ifPresent(filters -> filters.forEach(filter -> {
            Class<?> loadedClass;
            String clazz = Objects.requireNonNull(filter.get((Object)"className").unwrapped().toString(), "className must be provided: " + filter);
            String name = Optional.ofNullable(filter.get((Object)"name")).map(c -> c.unwrapped().toString()).orElse(clazz);
            boolean asyncSupported = this.extractAsyncSupported((ConfigObject)filter);
            Map<String, String> initParams = this.extractInitParams((ConfigObject)filter);
            String[] mappings = this.extractMappings((ConfigObject)filter);
            ClassLoader classLoader = this.getClassLoader();
            try {
                loadedClass = classLoader.loadClass(clazz.trim());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            FilterRegistration.Dynamic dynamic = this.addFilter(name, loadedClass);
            dynamic.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, mappings);
            initParams.forEach((arg_0, arg_1) -> ((FilterRegistration.Dynamic)dynamic).setInitParameter(arg_0, arg_1));
            if (asyncSupported) {
                dynamic.setAsyncSupported(true);
            } else {
                LOGGER.info("Filter {} is not set with asyncSupported=true", (Object)name);
            }
        }));
        this.safeConfigAccess(config, "playx.servlet.initializers", Config::getStringList).ifPresent(clazz -> clazz.forEach(init -> {
            ClassLoader classLoader = this.getClassLoader();
            try {
                Class<?> initializer = classLoader.loadClass(init.trim());
                ServletContainerInitializer instances = (ServletContainerInitializer)initializer.getConstructor(new Class[0]).newInstance(new Object[0]);
                instances.onStartup(this.findClasses(instances), (ServletContext)this);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }));
        if (!this.listeners.isEmpty()) {
            ServletContextEvent event = new ServletContextEvent((ServletContext)this);
            this.listeners.stream().filter(ServletContextListener.class::isInstance).map(ServletContextListener.class::cast).forEach(l -> l.contextInitialized(event));
        }
        this.filters.forEach(f -> {
            try {
                f.getInstance().init(f.toFilterConfig(this));
            }
            catch (ServletException e) {
                throw new IllegalStateException(e);
            }
        });
        this.servlets.sort(Comparator.comparing(DynamicServlet::getLoadOnStartup));
        this.servlets.forEach(s -> {
            try {
                s.getInstance().init(s.toServletConfig(this));
            }
            catch (ServletException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private Boolean extractAsyncSupported(ConfigObject filter) {
        return Optional.ofNullable(filter.get((Object)"asyncSupported")).filter(c -> c.valueType() == ConfigValueType.BOOLEAN).map(c -> (Boolean)Boolean.class.cast(c.unwrapped())).orElse(false);
    }

    private Map<String, String> extractInitParams(ConfigObject servlet) {
        return Optional.ofNullable(servlet.get((Object)"initParameters")).filter(c -> c.valueType() == ConfigValueType.LIST).map(list -> ((ConfigList)ConfigList.class.cast(list)).stream().filter(it -> it.valueType() == ConfigValueType.OBJECT).map(ConfigObject.class::cast).collect(Collectors.toMap(obj -> obj.get((Object)"name").unwrapped().toString(), obj -> obj.get((Object)"value").unwrapped().toString()))).orElseGet(Collections::emptyMap);
    }

    private String[] extractMappings(ConfigObject filter) {
        return Optional.ofNullable(filter.get((Object)"mappings")).filter(c -> c.valueType() == ConfigValueType.LIST).map(list -> (String[])((ConfigList)ConfigList.class.cast(list)).stream().map(c -> c.unwrapped().toString()).toArray(String[]::new)).orElseGet(() -> new String[0]);
    }

    private <T> Optional<T> safeConfigAccess(Config config, String key, BiFunction<Config, String, T> extractor) {
        if (config.hasPathOrNull(key) && !config.getIsNull(key)) {
            return Optional.of(extractor.apply(config, key));
        }
        return Optional.empty();
    }

    private Set<Class<?>> findClasses(ServletContainerInitializer i) {
        HandlesTypes annotation = i.getClass().getAnnotation(HandlesTypes.class);
        if (annotation == null || annotation.value().length == 0) {
            return null;
        }
        return Stream.of(annotation.value()).flatMap(k -> Stream.of(this.findClasses((Class<?>)k))).collect(Collectors.toSet());
    }

    protected Class<?>[] findClasses(Class<?> k) {
        return new Class[0];
    }

    public void stop() {
        this.servlets.stream().sorted(Comparator.comparing(DynamicServlet::getLoadOnStartup).reversed()).forEach(s -> s.getInstance().destroy());
        this.filters.forEach(f -> f.getInstance().destroy());
        if (!this.listeners.isEmpty()) {
            ServletContextEvent event = new ServletContextEvent((ServletContext)this);
            this.listeners.stream().filter(ServletContextListener.class::isInstance).map(ServletContextListener.class::cast).forEach(l -> l.contextDestroyed(event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Result> executeInvoke(ServletMatching servlet, Http.RequestHeader requestHeader, InputStream stream, String servletPath) {
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClassLoader());
        try {
            ResponseAdapter response = new ResponseAdapter((requestHeader.secure() ? "https" : "http") + "://" + requestHeader.host() + requestHeader.uri(), this);
            RequestAdapter request = new RequestAdapter(requestHeader, stream, (ServletResponse)response, this.injector, this, servlet.getDynamicServlet(), servletPath);
            request.setAttribute(ResponseAdapter.class.getName(), response);
            if (!servlet.getDynamicServlet().isAsyncSupported()) {
                CompletionStage completionStage = CompletableFuture.supplyAsync(() -> this.doExecute(servlet, response, request), this.getDefaultExecutor()).thenCompose(Function.identity());
                return completionStage;
            }
            CompletionStage<Result> completionStage = this.doExecute(servlet, response, request);
            return completionStage;
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Result> doExecute(ServletMatching matched, ResponseAdapter response, RequestAdapter request) {
        try {
            if (matched.getDynamicFilters().isEmpty()) {
                matched.getDynamicServlet().getInstance().service((ServletRequest)request, (ServletResponse)response);
            } else {
                new FilterChainImpl(matched.getDynamicFilters(), matched.getDynamicServlet()).doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (IOException | ServletException ex) {
            if (request.isAsyncStarted() && AsyncContextImpl.class.isInstance(request.getAsyncContext())) {
                ((AsyncContextImpl)AsyncContextImpl.class.cast(request.getAsyncContext())).onError(ex);
            } else {
                response.fail(ex);
            }
            CompletableFuture<Result> completableFuture = CompletableFuture.completedFuture(new Result(500, "Unexpected error", Collections.emptyMap(), HttpEntity.fromString((String)ex.getMessage(), (String)StandardCharsets.UTF_8.name())));
            return completableFuture;
        }
        finally {
            if (!request.isAsyncStarted()) {
                response.onComplete();
            }
        }
        return response.toResult();
    }

    public Optional<ServletMatching> findMatchingServlet(Http.RequestHeader requestHeader) {
        URI uri = URI.create(requestHeader.uri());
        String path = uri.getPath();
        if (!path.startsWith(this.getContextPath())) {
            return Optional.empty();
        }
        return this.findFirstMatchingServlet(path);
    }

    public Optional<ServletMatching> findFirstMatchingServlet(String path) {
        String matching = path.substring(this.getContextPath().length());
        return this.servlets.stream().map(servlet -> servlet.getMappings().stream().map(mapping -> this.findServletPath((String)mapping, matching)).filter(Objects::nonNull).findFirst().map(mapping -> new ServletMatching(this.findMatchingFilters(servlet.getName(), path), (DynamicServlet)servlet, (String)mapping))).filter(Optional::isPresent).findFirst().flatMap(Function.identity());
    }

    private List<DynamicFilter> findMatchingFilters(String servlet, String path) {
        if (this.filters.isEmpty()) {
            return Collections.emptyList();
        }
        return this.filters.stream().filter(f -> f.getServletNameMappings().contains(servlet) || f.getUrlPatternMappings().stream().anyMatch(it -> this.findServletPath((String)it, path) != null)).collect(Collectors.toList());
    }

    private String findServletPath(String mapping, String request) {
        if (mapping.endsWith("/*")) {
            String path = mapping.substring(0, mapping.length() - 1);
            if (request.startsWith(path)) {
                return path;
            }
            return null;
        }
        if (mapping.startsWith("*.")) {
            String extension = mapping.substring(1);
            if (request.endsWith(extension)) {
                return request;
            }
            return null;
        }
        if (mapping.equals(request) || "/".equals(mapping)) {
            return mapping;
        }
        return null;
    }

    public Executor getDefaultExecutor() {
        return this.executor;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new RequestDispatcherImpl(this, path);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getContext(String uripath) {
        return this;
    }

    public int getMajorVersion() {
        return 4;
    }

    public int getMinorVersion() {
        return 0;
    }

    public int getEffectiveMajorVersion() {
        return 4;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public String getMimeType(String file) {
        return null;
    }

    public Set<String> getResourcePaths(String path) {
        return Collections.emptySet();
    }

    public URL getResource(String path) {
        return this.getClassLoader().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.getClassLoader().getResourceAsStream(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.getRequestDispatcher("/");
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration<Servlet> getServlets() {
        return Collections.emptyEnumeration();
    }

    public Enumeration<String> getServletNames() {
        return Collections.emptyEnumeration();
    }

    public void log(String msg) {
        LOGGER.info(msg);
    }

    public void log(Exception exception, String msg) {
        LOGGER.error(msg, (Throwable)exception);
    }

    public void log(String message, Throwable throwable) {
        LOGGER.error(message, throwable);
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getServerInfo() {
        return "Play-Servlet-Bridge/1.0";
    }

    public String getInitParameter(String name) {
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.emptyEnumeration();
    }

    public boolean setInitParameter(String name, String value) {
        return false;
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.emptyEnumeration();
    }

    public void setAttribute(String name, Object object) {
    }

    public void removeAttribute(String name) {
    }

    public String getServletContextName() {
        return "";
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        DynamicServlet dynamicServlet = new DynamicServlet(servletName, servlet);
        this.servlets.add(dynamicServlet);
        return dynamicServlet;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        try {
            return this.addServlet(servletName, this.getClassLoader().loadClass(className));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.addServlet(servletName, this.createServlet(servletClass));
    }

    public ServletRegistration.Dynamic addJspFile(String jspName, String jspFile) {
        throw new UnsupportedOperationException();
    }

    public <T extends Servlet> T createServlet(Class<T> c) {
        return (T)((Servlet)this.newInstance(c));
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.servlets.stream().filter(s -> s.getName().equals(servletName)).findFirst().orElse(null);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.servlets.stream().flatMap(d -> d.getMappings().stream().map(e -> new AbstractMap.SimpleEntry<String, DynamicServlet>((String)e, (DynamicServlet)d))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        try {
            return this.addFilter(filterName, this.getClassLoader().loadClass(className));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        DynamicFilter dynamicFilter = new DynamicFilter(filterName, filter);
        this.filters.add(dynamicFilter);
        return dynamicFilter;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.addFilter(filterName, this.newInstance(filterClass));
    }

    public <T extends Filter> T createFilter(Class<T> c) {
        return (T)((Filter)this.newInstance(c));
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.filters.stream().filter(f -> f.getName().equals(filterName)).findFirst().orElse(null);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.filters.stream().flatMap(d -> d.getUrlPatternMappings().stream().map(e -> new AbstractMap.SimpleEntry<String, DynamicFilter>((String)e, (DynamicFilter)d))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public SessionCookieConfig getSessionCookieConfig() {
        throw new UnsupportedOperationException();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException();
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return Collections.emptySet();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return Collections.emptySet();
    }

    public void addListener(String className) {
        try {
            this.addListener(this.getClassLoader().loadClass(className.trim()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T extends EventListener> void addListener(T t) {
        if (!ServletContextListener.class.isInstance(t)) {
            LOGGER.error("Unsupported listener: " + t + ", only ServletContextListener are supported for now");
        }
        this.listeners.add(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.addListener(this.createListener(listenerClass));
    }

    public <T extends EventListener> T createListener(Class<T> c) {
        return (T)((EventListener)this.newInstance(c));
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException();
    }

    public ClassLoader getClassLoader() {
        return ((Environment)this.injector.instanceOf(Environment.class)).classLoader();
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException();
    }

    public String getVirtualServerName() {
        return "localhost";
    }

    public int getSessionTimeout() {
        return 30;
    }

    public void setSessionTimeout(int sessionTimeout) {
        throw new UnsupportedOperationException();
    }

    public String getRequestCharacterEncoding() {
        return this.requestEncoding;
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.requestEncoding = encoding;
    }

    public String getResponseCharacterEncoding() {
        return this.responseEncoding;
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.responseEncoding = encoding;
    }

    private <T> T newInstance(Class<T> c) {
        try {
            return (T)this.injector.instanceOf(c);
        }
        catch (RuntimeException re) {
            try {
                return c.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                re.addSuppressed(e);
                throw re;
            }
        }
    }

    public static class ServletMatching {
        private final List<DynamicFilter> dynamicFilters;
        private final DynamicServlet dynamicServlet;
        private final String servletPath;

        private ServletMatching(List<DynamicFilter> dynamicFilters, DynamicServlet dynamicServlet, String servletPath) {
            this.dynamicFilters = dynamicFilters;
            this.dynamicServlet = dynamicServlet;
            this.servletPath = servletPath;
        }

        public List<DynamicFilter> getDynamicFilters() {
            return this.dynamicFilters;
        }

        public DynamicServlet getDynamicServlet() {
            return this.dynamicServlet;
        }

        public String getServletPath() {
            return this.servletPath;
        }
    }
}

