/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.microprofile.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.config.spi.ConfigSource;
import play.api.Environment;

public class TypesafeConfigConfigSource
implements ConfigSource {
    private volatile Map<String, String> configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getProperties() {
        if (this.configuration == null) {
            TypesafeConfigConfigSource typesafeConfigConfigSource = this;
            synchronized (typesafeConfigConfigSource) {
                if (this.configuration == null) {
                    HashMap<String, String> aggregator = new HashMap<String, String>();
                    try {
                        Instance environment;
                        CDI current = CDI.current();
                        Instance configs = current.select(Config.class, new Annotation[0]);
                        if (configs.isResolvable()) {
                            Config config = (Config)configs.get();
                            this.visit(aggregator, config, "");
                        }
                        if ((environment = current.select(Environment.class, new Annotation[0])).isResolvable()) {
                            Environment env = (Environment)environment.get();
                            aggregator.put("playx.application.mode", env.mode().asJava().name());
                            aggregator.put("playx.application.home", env.rootPath().getAbsolutePath());
                        }
                    }
                    catch (RuntimeException re) {
                        return Collections.emptyMap();
                    }
                    this.configuration = aggregator;
                }
            }
        }
        return this.configuration;
    }

    public String getValue(String propertyName) {
        return this.getProperties().get(propertyName);
    }

    public String getName() {
        return "cdi-typesafe-config";
    }

    private void visit(Map<String, String> aggregator, Config config, String prefix) {
        config.entrySet().forEach(e -> {
            ConfigValue value = (ConfigValue)e.getValue();
            String currentKey = prefix + (prefix.isEmpty() ? "" : ".") + (String)e.getKey();
            switch (value.valueType()) {
                case OBJECT: {
                    this.visit(aggregator, ((ConfigObject)ConfigObject.class.cast(value)).toConfig(), currentKey);
                    break;
                }
                case LIST: {
                    aggregator.put(currentKey, ((ConfigList)ConfigList.class.cast(value)).stream().map(v -> String.valueOf(v.unwrapped())).collect(Collectors.joining(",")));
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    aggregator.put(currentKey, String.valueOf(value.unwrapped()));
                }
            }
        });
    }
}

