/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.ioc;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.stream.Materializer;
import play.ApplicationLoader;
import play.DefaultApplication;
import play.api.Application;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode;
import play.api.http.HttpConfiguration;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpRequestHandler;
import play.api.inject.BindingKey;
import play.api.mvc.request.RequestFactory;
import play.inject.Injector;
import scala.concurrent.Future;
import scala.reflect.ClassTag;

public class IoCLoader
implements ApplicationLoader {
    public play.Application load(ApplicationLoader.Context context) {
        Config config = context.initialConfig();
        Collection loaders = this.safeConfigAccess(config, "playx.ioc.loaders", Config::getStringList).orElseGet(Collections::emptyList);
        if (loaders.isEmpty()) {
            throw new IllegalArgumentException("No loader set for playx.ioc.loaders");
        }
        List appLoaders = loaders.stream().map(clazz -> {
            try {
                return (ApplicationLoader)ApplicationLoader.class.cast(context.environment().classLoader().loadClass((String)clazz).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
        LinkedHashMap<ApplicationLoader, play.Application> instances = new LinkedHashMap<ApplicationLoader, play.Application>();
        for (ApplicationLoader loader : appLoaders) {
            if (Consumer.class.isInstance(loader)) {
                ((Consumer)Consumer.class.cast(loader)).accept(instances.values());
            }
            instances.put(loader, loader.load(context));
        }
        Map<String, String> routingTable = this.safeConfigAccess(config, "playx.ioc.routing", Config::getObjectList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(it -> (String)it.keySet().iterator().next(), it -> ((ConfigValue)it.values().iterator().next()).render()));
        return new IoCApplication(instances, routingTable).asJava();
    }

    private <T> Optional<T> safeConfigAccess(Config config, String key, BiFunction<Config, String, T> extractor) {
        if (config.hasPathOrNull(key) && !config.getIsNull(key)) {
            return Optional.of(extractor.apply(config, key));
        }
        return Optional.empty();
    }

    private static class IoCApplication
    implements Application {
        private final Collection<play.Application> delegates;
        private final play.api.inject.Injector injector;
        private final Application scalaRef;
        private final play.Application java;

        IoCApplication(Map<ApplicationLoader, play.Application> values, Map<String, String> routing) {
            this.delegates = new ArrayList<play.Application>(values.values());
            this.injector = new IoCInjector(values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((play.Application)e.getValue()).injector(), (a, b) -> {
                throw new IllegalStateException("Conflicting keys for " + a + "/" + b);
            }, LinkedHashMap::new)), routing);
            this.scalaRef = this.delegates.iterator().next().asScala();
            this.java = new DefaultApplication((Application)this, this.injector.asJava());
            this.playxIntegration();
        }

        private void playxIntegration() {
            try {
                Class<?> clazz = this.classloader().loadClass("com.github.rmannibucau.playx.servlet.servlet.api.ServletFilter");
                ((Consumer)Consumer.class.cast(this.injector.instanceOf(clazz))).accept(this.injector.instanceOf(clazz));
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }

        public play.api.inject.Injector injector() {
            return this.injector;
        }

        public File path() {
            return this.scalaRef.path();
        }

        public ClassLoader classloader() {
            return this.scalaRef.classloader();
        }

        public Mode mode() {
            return this.scalaRef.mode();
        }

        public Environment environment() {
            return this.scalaRef.environment();
        }

        public boolean isDev() {
            return this.scalaRef.isDev();
        }

        public boolean isTest() {
            return this.scalaRef.isTest();
        }

        public boolean isProd() {
            return this.scalaRef.isProd();
        }

        public Configuration configuration() {
            return this.scalaRef.configuration();
        }

        public ActorSystem actorSystem() {
            return this.scalaRef.actorSystem();
        }

        public Materializer materializer() {
            return this.scalaRef.materializer();
        }

        public CoordinatedShutdown coordinatedShutdown() {
            return this.scalaRef.coordinatedShutdown();
        }

        public RequestFactory requestFactory() {
            return this.scalaRef.requestFactory();
        }

        public HttpRequestHandler requestHandler() {
            return this.scalaRef.requestHandler();
        }

        public HttpErrorHandler errorHandler() {
            return this.scalaRef.errorHandler();
        }

        public play.Application asJava() {
            return this.java;
        }

        public Future<?> stop() {
            return this.scalaRef.stop();
        }

        public HttpConfiguration httpConfiguration() {
            return this.scalaRef.httpConfiguration();
        }

        public boolean globalApplicationEnabled() {
            return this.scalaRef.globalApplicationEnabled();
        }
    }

    private static class IoCInjector
    implements Injector,
    play.api.inject.Injector {
        private final Map<ApplicationLoader, Injector> injectors;
        private final Map<String, String> routing;

        private IoCInjector(Map<ApplicationLoader, Injector> injectors, Map<String, String> routing) {
            this.injectors = injectors;
            this.routing = routing;
        }

        public <T> T instanceOf(ClassTag<T> tag) {
            return this.instanceOf(tag.runtimeClass());
        }

        public <T> T instanceOf(Class<T> clazz) {
            return this.instanceOf(BindingKey.apply(clazz));
        }

        public <T> T instanceOf(BindingKey<T> key) {
            ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
            for (Injector delegate : this.sortInjectorsFor(key.clazz().getName())) {
                try {
                    return (T)delegate.instanceOf(key);
                }
                catch (RuntimeException re) {
                    errors.add(re);
                }
            }
            RuntimeException error = (RuntimeException)errors.iterator().next();
            errors.stream().skip(1L).forEach(error::addSuppressed);
            throw error;
        }

        private Collection<Injector> sortInjectorsFor(String name) {
            if (this.routing.isEmpty()) {
                return this.injectors.values();
            }
            Optional<Collection> sortedInjectors = this.routing.entrySet().stream().filter(e -> name.startsWith((String)e.getKey())).findFirst().map(Map.Entry::getValue).map(preference -> this.injectors.entrySet().stream().sorted((e1, e2) -> {
                String e1Clazz = ((ApplicationLoader)e1.getKey()).getClass().getSimpleName();
                if (e1Clazz.toLowerCase(Locale.ROOT).contains((CharSequence)preference)) {
                    return -1;
                }
                String e2Clazz = ((ApplicationLoader)e2.getKey()).getClass().getSimpleName();
                if (e2Clazz.toLowerCase(Locale.ROOT).contains((CharSequence)preference)) {
                    return 1;
                }
                return e1Clazz.compareTo(e2Clazz);
            }).map(Map.Entry::getValue).collect(Collectors.toList()));
            return sortedInjectors.orElseGet(this.injectors::values);
        }

        public Injector asJava() {
            return this;
        }

        public play.api.inject.Injector asScala() {
            return this;
        }
    }
}

