/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.playx.cdi;

import akka.actor.ActorSystem;
import akka.stream.Materializer;
import com.github.rmannibucau.playx.cdi.PackageCleaner;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValueType;
import controllers.Assets;
import controllers.AssetsConfiguration;
import controllers.DefaultAssetsMetadata;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.configurator.BeanConfigurator;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Singleton;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import play.ApplicationLoader;
import play.BuiltInComponentsFromContext;
import play.LoggerConfigurator;
import play.api.Application;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode;
import play.api.OptionalSourceMapper;
import play.api.http.ActionCompositionConfiguration;
import play.api.http.CookiesConfiguration;
import play.api.http.EnabledFilters;
import play.api.http.FileMimeTypesConfiguration;
import play.api.http.FlashConfiguration;
import play.api.http.HttpConfiguration;
import play.api.http.HttpRequestHandler;
import play.api.http.ParserConfiguration;
import play.api.http.SecretConfiguration;
import play.api.http.SessionConfiguration;
import play.api.i18n.DefaultLangsProvider;
import play.api.i18n.DefaultMessagesApiProvider;
import play.api.i18n.Langs;
import play.api.i18n.MessagesApi;
import play.api.inject.BindingKey;
import play.api.inject.QualifierAnnotation;
import play.api.inject.QualifierClass;
import play.api.inject.QualifierInstance;
import play.api.inject.RoutesProvider;
import play.api.libs.Files;
import play.api.libs.concurrent.DefaultFutures;
import play.api.libs.concurrent.ExecutionContextProvider;
import play.api.mvc.BodyParsers;
import play.api.mvc.CookieHeaderEncoding;
import play.api.mvc.DefaultActionBuilderImpl;
import play.api.mvc.DefaultControllerComponents;
import play.api.mvc.DefaultCookieHeaderEncoding;
import play.api.mvc.DefaultMessagesActionBuilderImpl;
import play.api.mvc.DefaultMessagesControllerComponents;
import play.api.mvc.DefaultPlayBodyParsers;
import play.api.mvc.MessagesControllerComponents;
import play.api.mvc.request.DefaultRequestFactory;
import play.api.mvc.request.RequestFactory;
import play.core.WebCommands;
import play.core.j.DefaultJavaContextComponents;
import play.core.j.JavaContextComponents;
import play.core.j.JavaHttpErrorHandlerAdapter;
import play.core.j.JavaRouterAdapter;
import play.http.HttpErrorHandler;
import play.inject.ApplicationLifecycle;
import play.inject.Injector;
import play.libs.concurrent.HttpExecutionContext;
import play.libs.crypto.CSRFTokenSigner;
import play.libs.crypto.CookieSigner;
import play.mvc.EssentialFilter;
import play.mvc.FileMimeTypes;
import play.routing.Router;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.compat.java8.OptionConverters;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.reflect.ClassTag;

public class CdiLoader
implements ApplicationLoader,
Consumer<Collection<play.Application>> {
    private final Collection<play.Application> otherApplications = new ArrayList<play.Application>();
    private final BiFunction<ApplicationLoader.Context, String, Class<?>> classLoader = (context, className) -> {
        try {
            return context.environment().classLoader().loadClass(className.trim());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    };

    public play.Application load(ApplicationLoader.Context context) {
        Config config = context.initialConfig();
        BiFunction<Boolean, String, Stream> packageLoader = (recursive, pckName) -> {
            ClassLoader loader = context.environment().classLoader();
            String trimmed = pckName.trim();
            try {
                return Stream.of(loader.loadClass(trimmed + ".package-info.class").getPackage());
            }
            catch (ClassNotFoundException e) {
                return Optional.ofNullable(Package.getPackage(trimmed)).map(Stream::of).orElseGet(() -> Optional.of(trimmed).map(name -> this.findPackageFromClassLoader(loader, (String)name, (boolean)recursive).stream().map(it -> this.classLoader.apply(context, (String)it)).map(Class::getPackage)).orElseThrow(() -> new IllegalArgumentException("can't find package: " + trimmed, e)));
            }
        };
        SeContainerInitializer initializer = SeContainerInitializer.newInstance().setClassLoader(context.environment().classLoader());
        if (CdiLoader.safeConfigAccess(config, "playx.cdi.container.disableDiscovery", Config::getBoolean).orElse(false).booleanValue()) {
            initializer.disableDiscovery();
        }
        CdiLoader.safeConfigAccess(config, "playx.cdi.container.beanClasses", Config::getStringList).map(list -> (Class[])list.stream().map(c -> this.classLoader.apply(context, (String)c)).toArray(Class[]::new)).ifPresent(arg_0 -> ((SeContainerInitializer)initializer).addBeanClasses(arg_0));
        CdiLoader.safeConfigAccess(config, "playx.cdi.container.packages", Config::getList).ifPresent(pcks -> pcks.forEach(value -> {
            if (value.valueType() == ConfigValueType.OBJECT) {
                ConfigObject object = (ConfigObject)ConfigObject.class.cast(value);
                boolean recursive = CdiLoader.safeConfigAccess(object.toConfig(), "recursive", Config::getBoolean).orElse(false);
                String pck = CdiLoader.safeConfigAccess(object.toConfig(), "package", Config::getString).orElseThrow(() -> new IllegalArgumentException("Missing package value in " + value)).trim();
                ((Stream)packageLoader.apply(recursive, pck)).forEach(pckIt -> initializer.addPackages(recursive, new Package[]{pckIt}));
            } else if (value.valueType() == ConfigValueType.STRING) {
                ((Stream)packageLoader.apply(false, value.unwrapped().toString().trim())).forEach(xva$0 -> initializer.addPackages(new Package[]{xva$0}));
            } else {
                throw new IllegalArgumentException("Unsupported configuration: " + value);
            }
        }));
        CdiLoader.safeConfigAccess(config, "playx.cdi.container.properties", Config::getObjectList).ifPresent(properties -> properties.forEach(value -> initializer.addProperty(value.get((Object)"key").render(), value.get((Object)"value").unwrapped())));
        CdiLoader.safeConfigAccess(config, "playx.cdi.container.extensions", Config::getStringList).ifPresent(extensions -> {
            Class[] extInstances = (Class[])extensions.stream().map(c -> this.classLoader.apply(context, (String)c)).toArray(Class[]::new);
            initializer.addExtensions(extInstances);
        });
        CdiLoader.safeConfigAccess(config, "playx.cdi.container.decorators", Config::getStringList).ifPresent(extensions -> initializer.enableDecorators((Class[])extensions.stream().map(c -> this.classLoader.apply(context, (String)c)).toArray(Class[]::new)));
        CdiLoader.safeConfigAccess(config, "playx.cdi.container.interceptors", Config::getStringList).ifPresent(extensions -> initializer.enableInterceptors((Class[])extensions.stream().map(c -> this.classLoader.apply(context, (String)c)).toArray(Class[]::new)));
        CdiLoader.safeConfigAccess(config, "playx.cdi.container.alternatives", Config::getStringList).ifPresent(extensions -> initializer.selectAlternatives((Class[])extensions.stream().map(c -> this.classLoader.apply(context, (String)c)).toArray(Class[]::new)));
        CdiLoader.safeConfigAccess(config, "playx.cdi.container.alternativeStereotypes", Config::getStringList).ifPresent(extensions -> {
            Class[] alternativeStereotypeClasses = (Class[])extensions.stream().map(c -> this.classLoader.apply(context, (String)c)).toArray(Class[]::new);
            initializer.selectAlternativeStereotypes(alternativeStereotypeClasses);
        });
        CdiInjector injector = new CdiInjector();
        CdiApplication application = new CdiApplication(injector, context);
        this.addProvidedBeans(context, initializer, injector, application);
        SeContainer container = initializer.initialize();
        injector.container = container;
        context.applicationLifecycle().addStopHook(() -> CompletableFuture.runAsync(() -> ((SeContainer)container).close(), Runnable::run));
        return application;
    }

    private Collection<String> findPackageFromClassLoader(ClassLoader loader, String name, boolean recursive) {
        String pck = name.replace(".", "/");
        try {
            Enumeration<URL> urls = loader.getResources(pck);
            ArrayList<String> names = new ArrayList<String>();
            while (urls.hasMoreElements()) {
                boolean exists;
                File next = CdiLoader.toFile(urls.nextElement());
                boolean bl = exists = next != null && next.exists();
                if (exists && !next.isDirectory()) {
                    JarFile file = new JarFile(next);
                    Throwable throwable = null;
                    try {
                        ArrayList<JarEntry> entries = Collections.list(file.entries());
                        HashSet<String> packages = new HashSet<String>();
                        List classes = entries.stream().filter(it -> {
                            String eName = it.getName();
                            return eName.startsWith(pck + '/') && eName.endsWith(".class") && (recursive || eName.lastIndexOf(47, pck.length()) == pck.length());
                        }).map(ZipEntry::getName).map(clazz -> clazz.replace('/', '.').substring(0, clazz.length() - ".class".length())).filter(s -> {
                            String sPck = s.substring(0, s.lastIndexOf(46));
                            return packages.add(sPck);
                        }).sorted().collect(Collectors.toList());
                        if (name.equals(((String)classes.get(0)).substring(0, ((String)classes.get(0)).lastIndexOf(46)))) {
                            names.add((String)classes.iterator().next());
                            continue;
                        }
                        if (!recursive) continue;
                        PackageCleaner packageCleaner = new PackageCleaner();
                        Collection<String> pcks = packageCleaner.removeOverlaps(packages);
                        names.addAll(classes.stream().filter(className -> pcks.stream().anyMatch(pack -> className.startsWith((String)pack) && !className.substring(pack.length() + 1).contains("."))).collect(Collectors.toList()));
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (file == null) continue;
                        if (throwable != null) {
                            try {
                                file.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        file.close();
                        continue;
                    }
                }
                if (!exists) continue;
                Optional.ofNullable(next.listFiles()).map(Stream::of).orElseGet(Stream::empty).filter(c -> c.getName().endsWith(".class")).findFirst().ifPresent(c -> names.add(name + '.' + c.getName().substring(0, c.getName().length() - ".class".length())));
            }
            if (!names.isEmpty()) {
                return names;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private void addProvidedBeans(final ApplicationLoader.Context context, SeContainerInitializer initializer, final Injector injector, final play.Application application) {
        final play.Environment environment = context.environment();
        final Config config = application.config();
        final Configuration configuration = new Configuration(config);
        initializer.addExtensions(new Extension[]{new Extension(){

            void addSingletons(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
                ArrayList extensions = new ArrayList();
                try {
                    extensions.add(environment.classLoader().loadClass("com.github.rmannibucau.playx.servlet.servlet.api.ServletFilter"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (CdiLoader.safeConfigAccess(context.initialConfig(), "playx.cdi.beans.defaults", Config::getBoolean).orElse(true).booleanValue()) {
                    Stream.concat(Stream.of(Assets.class, Files.DefaultTemporaryFileCreator.class, Files.DefaultTemporaryFileReaper.class, DefaultPlayBodyParsers.class, BodyParsers.Default.class, DefaultActionBuilderImpl.class, DefaultControllerComponents.class, DefaultMessagesActionBuilderImpl.class, DefaultMessagesControllerComponents.class, play.libs.concurrent.DefaultFutures.class, DefaultFutures.class, HttpExecutionContext.class, DefaultAssetsMetadata.class), extensions.stream()).forEach(it -> event.addAnnotatedType(beanManager.createAnnotatedType(it)));
                }
            }

            void restrictTypesForDefaultMessagesControllerComponents(@Observes ProcessBeanAttributes<DefaultMessagesControllerComponents> pba) {
                pba.configureBeanAttributes().types(new Type[]{MessagesControllerComponents.class, Object.class});
            }

            void addProvidedBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
                if (CdiLoader.safeConfigAccess(context.initialConfig(), "playx.cdi.beans.defaults", Config::getBoolean).orElse(true).booleanValue()) {
                    this.addPlayBeans(event);
                }
                this.addCustomBeans(event, beanManager);
            }

            private void addCustomBeans(AfterBeanDiscovery event, BeanManager beanManager) {
                CdiLoader.safeConfigAccess(context.initialConfig(), "playx.cdi.beans.customs", Config::getObjectList).ifPresent(beans -> beans.forEach(bean -> {
                    Class scopeAnnotation;
                    String scope;
                    String className = Objects.requireNonNull(bean.get((Object)"className"), "className can't be null: " + bean).unwrapped().toString();
                    Class beanClass = (Class)CdiLoader.this.classLoader.apply(context, className);
                    switch (scope = Optional.ofNullable(bean.get((Object)"scope")).map(s -> s.unwrapped().toString()).orElse("javax.enterprise.context.Dependent")) {
                        case "javax.enterprise.context.ApplicationScoped": {
                            scopeAnnotation = ApplicationScoped.class;
                            break;
                        }
                        case "javax.inject.Singleton": {
                            scopeAnnotation = Singleton.class;
                            break;
                        }
                        case "javax.enterprise.context.Dependent": {
                            scopeAnnotation = Dependent.class;
                            break;
                        }
                        default: {
                            scopeAnnotation = (Class)CdiLoader.this.classLoader.apply(context, scope);
                        }
                    }
                    BeanConfigurator configurator = event.addBean();
                    Optional.ofNullable(bean.get((Object)"id")).map(s -> s.unwrapped().toString()).ifPresent(arg_0 -> ((BeanConfigurator)configurator).id(arg_0));
                    configurator.beanClass(beanClass).scope(scopeAnnotation);
                    Optional.ofNullable(bean.get((Object)"transitiveTypeClosure")).filter(v -> (Boolean)Boolean.class.cast(v.unwrapped())).map(v -> configurator.addTransitiveTypeClosure((Type)beanClass)).orElseGet(() -> configurator.types(new Type[]{beanClass, Object.class}));
                    Optional.ofNullable(bean.get((Object)"qualifiers")).map(v -> {
                        throw new IllegalArgumentException("Not yet supported");
                    }).orElseGet(() -> configurator.qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}));
                    this.addBeanLifecycle(beanManager, beanClass, configurator);
                }));
            }

            private <T> void addBeanLifecycle(BeanManager beanManager, Class<T> beanClass, BeanConfigurator<T> configurator) {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(beanClass);
                InjectionTarget injectionTarget = beanManager.createInjectionTarget(annotatedType);
                configurator.createWith(arg_0 -> ((InjectionTarget)injectionTarget).produce(arg_0)).destroyWith((o, ctx) -> injectionTarget.dispose(o));
            }

            private void addPlayBeans(AfterBeanDiscovery event) {
                this.addBean(event, new LazyProvider(() -> LoggerConfigurator.apply((ClassLoader)environment.classLoader()).map(lc -> {
                    lc.configure(environment, context.initialConfig(), Collections.emptyMap());
                    return lc.loggerFactory();
                }).orElseGet(LoggerFactory::getILoggerFactory)), ILoggerFactory.class, new Class[0]);
                this.addBean(event, () -> environment, play.Environment.class, new Class[0]);
                this.addBean(event, () -> ((play.Environment)environment).asScala(), Environment.class, new Class[0]);
                this.addBean(event, () -> ((ApplicationLoader.Context)context).applicationLifecycle(), ApplicationLifecycle.class, new Class[0]);
                this.addBean(event, () -> context.applicationLifecycle().asScala(), play.api.inject.ApplicationLifecycle.class, new Class[0]);
                this.addBean(event, () -> config, Config.class, new Class[0]);
                this.addBean(event, () -> configuration, Configuration.class, new Class[0]);
                this.addBean(event, () -> application, play.Application.class, new Class[0]);
                this.addBean(event, () -> ((play.Application)application).asScala(), Application.class, new Class[0]);
                this.addBean(event, () -> injector, Injector.class, new Class[0]);
                this.addBean(event, () -> ((Injector)injector).asScala(), play.api.inject.Injector.class, new Class[0]);
                this.addBean(event, () -> context.asScala().webCommands(), WebCommands.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> new OptionalSourceMapper(OptionConverters.toScala((Optional)context.sourceMapper()))), OptionalSourceMapper.class, new Class[0]);
                event.addBean().id("playx.cdi.beans.builtin.applications").beanClass(null).types(new Type[]{new TypeLiteral<Collection<play.Application>>(){}.getType(), Object.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(Dependent.class).createWith(ctx -> CdiLoader.this.otherApplications);
                LazyProvider langs = new LazyProvider(() -> new DefaultLangsProvider(configuration).get());
                this.addBean(event, langs, Langs.class, new Class[0]);
                this.addBean(event, () -> ((Langs)langs.get()).asJava(), play.i18n.Langs.class, new Class[0]);
                BuiltInComponentsFromContext builtInComponentsFromContext = new BuiltInComponentsFromContext(context){
                    private JavaRouterAdapter router;

                    public Router router() {
                        return this.router == null ? (this.router = new JavaRouterAdapter(new RoutesProvider(injector.asScala(), environment.asScala(), configuration, this.httpConfiguration()).get())) : this.router;
                    }

                    public List<EssentialFilter> httpFilters() {
                        EnabledFilters enabledFilters = new EnabledFilters(environment.asScala(), configuration, injector.asScala());
                        return JavaConverters.asJavaCollection((Iterable)enabledFilters.filters().toList()).stream().map(play.api.mvc.EssentialFilter::asJava).collect(Collectors.toList());
                    }
                };
                LazyProvider httpConfiguration = new LazyProvider(() -> ((BuiltInComponentsFromContext)builtInComponentsFromContext).httpConfiguration());
                LazyProvider cookiesConfiguration = new LazyProvider(() -> ((HttpConfiguration)httpConfiguration.get()).cookies());
                LazyProvider messagesApi = new LazyProvider(() -> new DefaultMessagesApiProvider(environment.asScala(), configuration, (Langs)langs.get(), (HttpConfiguration)httpConfiguration.get()).get());
                this.addBean(event, messagesApi, MessagesApi.class, new Class[0]);
                this.addBean(event, () -> ((MessagesApi)messagesApi.get()).asJava(), play.i18n.MessagesApi.class, new Class[0]);
                this.addBean(event, httpConfiguration, HttpConfiguration.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> ((HttpConfiguration)httpConfiguration.get()).parser()), ParserConfiguration.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> ((HttpConfiguration)httpConfiguration.get()).session()), SessionConfiguration.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> ((HttpConfiguration)httpConfiguration.get()).secret()), SecretConfiguration.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> ((HttpConfiguration)httpConfiguration.get()).flash()), FlashConfiguration.class, new Class[0]);
                this.addBean(event, cookiesConfiguration, CookiesConfiguration.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> ((HttpConfiguration)httpConfiguration.get()).actionComposition()), ActionCompositionConfiguration.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> ((HttpConfiguration)httpConfiguration.get()).fileMimeTypes()), FileMimeTypesConfiguration.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> new DefaultCookieHeaderEncoding((CookiesConfiguration)cookiesConfiguration.get())), CookieHeaderEncoding.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> AssetsConfiguration.fromConfiguration((Configuration)configuration, (Mode)environment.mode().asScala())), AssetsConfiguration.class, new Class[0]);
                LazyProvider instance = new LazyProvider(() -> Files.TemporaryFileReaperConfiguration$.MODULE$.fromConfiguration(configuration));
                this.addBean(event, instance, Files.TemporaryFileReaperConfiguration.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> builtInComponentsFromContext.router().asScala()), play.api.routing.Router.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> ((BuiltInComponentsFromContext)builtInComponentsFromContext).router()), Router.class, new Class[0]);
                LazyProvider actorSystem = new LazyProvider(() -> ((BuiltInComponentsFromContext)builtInComponentsFromContext).actorSystem());
                this.addBean(event, actorSystem, ActorSystem.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> ((BuiltInComponentsFromContext)builtInComponentsFromContext).materializer()), Materializer.class, new Class[0]);
                LazyProvider executionContextExecutor = new LazyProvider(() -> new ExecutionContextProvider((ActorSystem)actorSystem.get()).get());
                this.addBean(event, executionContextExecutor, ExecutionContextExecutor.class, Executor.class, ExecutionContext.class);
                LazyProvider httpRequestHandler = new LazyProvider(() -> ((BuiltInComponentsFromContext)builtInComponentsFromContext).httpRequestHandler());
                this.addBean(event, httpRequestHandler, play.http.HttpRequestHandler.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> ((play.http.HttpRequestHandler)httpRequestHandler.get()).asScala()), HttpRequestHandler.class, new Class[0]);
                LazyProvider requestFactory = new LazyProvider(() -> new DefaultRequestFactory((HttpConfiguration)httpConfiguration.get()));
                this.addBean(event, requestFactory, RequestFactory.class, new Class[0]);
                LazyProvider fileMimeTypes = new LazyProvider(() -> ((BuiltInComponentsFromContext)builtInComponentsFromContext).fileMimeTypes());
                this.addBean(event, fileMimeTypes, FileMimeTypes.class, new Class[0]);
                this.addBean(event, new LazyProvider(() -> ((FileMimeTypes)fileMimeTypes.get()).asScala()), play.api.http.FileMimeTypes.class, new Class[0]);
                LazyProvider javaContextComponents = new LazyProvider(() -> new DefaultJavaContextComponents(((MessagesApi)messagesApi.get()).asJava(), ((Langs)langs.get()).asJava(), (FileMimeTypes)fileMimeTypes.get(), (HttpConfiguration)httpConfiguration.get()));
                LazyProvider errorHandler = new LazyProvider(() -> ((BuiltInComponentsFromContext)builtInComponentsFromContext).httpErrorHandler());
                this.addBean(event, new LazyProvider(() -> new JavaHttpErrorHandlerAdapter((HttpErrorHandler)errorHandler.get(), (JavaContextComponents)javaContextComponents.get())), play.api.http.HttpErrorHandler.class, new Class[0]);
                this.addBean(event, errorHandler, HttpErrorHandler.class, new Class[0]);
                LazyProvider cookieSigner = new LazyProvider(() -> ((BuiltInComponentsFromContext)builtInComponentsFromContext).cookieSigner());
                this.addBean(event, cookieSigner, CookieSigner.class, new Class[0]);
                this.addBean(event, () -> ((CookieSigner)cookieSigner.get()).asScala(), play.api.libs.crypto.CookieSigner.class, new Class[0]);
                LazyProvider csrfTokenSigner = new LazyProvider(() -> ((BuiltInComponentsFromContext)builtInComponentsFromContext).csrfTokenSigner());
                this.addBean(event, csrfTokenSigner, CSRFTokenSigner.class, new Class[0]);
                this.addBean(event, () -> ((CSRFTokenSigner)csrfTokenSigner.get()).asScala(), play.api.libs.crypto.CSRFTokenSigner.class, new Class[0]);
            }

            private <T> void addBean(AfterBeanDiscovery event, Supplier<T> instance, Class<T> mainApi, Class<?> ... types) {
                event.addBean().id(this.toId(mainApi)).beanClass(mainApi).types((Type[])Stream.concat(Stream.of(mainApi), Stream.concat(Stream.of(types), Stream.of(Object.class))).toArray(Class[]::new)).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(Dependent.class).createWith(ctx -> instance.get());
            }

            private <T> String toId(Class<T> type) {
                return "playx.cdi.beans.builtin." + type.getName();
            }
        }});
    }

    @Override
    public void accept(Collection<play.Application> applications) {
        this.otherApplications.addAll(applications);
    }

    private static <T> Optional<T> safeConfigAccess(Config config, String key, BiFunction<Config, String, T> extractor) {
        if (config.hasPathOrNull(key) && !config.getIsNull(key)) {
            return Optional.of(extractor.apply(config, key));
        }
        return Optional.empty();
    }

    private static File toFile(URL url) {
        if ("jar".equals(url.getProtocol())) {
            try {
                String spec = url.getFile();
                int separator = spec.indexOf(33);
                if (separator == -1) {
                    return null;
                }
                return CdiLoader.toFile(new URL(spec.substring(0, separator + 1)));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if ("file".equals(url.getProtocol())) {
            String path = CdiLoader.decode(url.getFile());
            if (path.endsWith("!")) {
                path = path.substring(0, path.length() - 1);
            }
            return new File(path);
        }
        return null;
    }

    private static String decode(String fileName) {
        if (fileName.indexOf(37) == -1) {
            return fileName;
        }
        StringBuilder result = new StringBuilder(fileName.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < fileName.length()) {
            char c = fileName.charAt(i);
            if (c == '%') {
                out.reset();
                do {
                    if (i + 2 >= fileName.length()) {
                        throw new IllegalArgumentException("Incomplete % sequence at: " + i);
                    }
                    int d1 = Character.digit(fileName.charAt(i + 1), 16);
                    int d2 = Character.digit(fileName.charAt(i + 2), 16);
                    if (d1 == -1 || d2 == -1) {
                        throw new IllegalArgumentException("Invalid % sequence (" + fileName.substring(i, i + 3) + ") at: " + String.valueOf(i));
                    }
                    out.write((byte)((d1 << 4) + d2));
                } while ((i += 3) < fileName.length() && fileName.charAt(i) == '%');
                result.append(out.toString());
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    private static class LazyProvider<T>
    implements Supplier<T> {
        private final AtomicReference<T> ref = new AtomicReference();
        private final Supplier<T> delegate;

        private LazyProvider(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            T val = this.ref.get();
            if (val == null) {
                LazyProvider lazyProvider = this;
                synchronized (lazyProvider) {
                    val = this.ref.get();
                    if (val == null && !this.ref.compareAndSet(null, val = this.delegate.get())) {
                        val = this.ref.get();
                    }
                }
            }
            return val;
        }
    }

    private static class CdiApplication
    implements play.Application {
        private final Application scala;
        private final Injector injector;
        private final ApplicationLoader.Context context;

        private CdiApplication(Injector injector, ApplicationLoader.Context context) {
            this.injector = injector;
            this.context = context;
            this.scala = new CdiScalaApplication(this);
        }

        public Application getWrappedApplication() {
            return this.asScala();
        }

        public Application asScala() {
            return this.scala;
        }

        public Config config() {
            return this.context.initialConfig();
        }

        public Injector injector() {
            return this.injector;
        }
    }

    private static class CdiScalaApplication
    implements Application {
        private final CdiApplication java;

        private CdiScalaApplication(CdiApplication cdiApplication) {
            this.java = cdiApplication;
        }

        public ActorSystem actorSystem() {
            return (ActorSystem)this.java.injector.instanceOf(ActorSystem.class);
        }

        public Materializer materializer() {
            return (Materializer)this.java.injector.instanceOf(Materializer.class);
        }

        public RequestFactory requestFactory() {
            return (RequestFactory)this.java.injector.instanceOf(RequestFactory.class);
        }

        public HttpRequestHandler requestHandler() {
            return (HttpRequestHandler)this.java.injector.instanceOf(HttpRequestHandler.class);
        }

        public play.api.http.HttpErrorHandler errorHandler() {
            return (play.api.http.HttpErrorHandler)this.java.injector.instanceOf(play.api.http.HttpErrorHandler.class);
        }

        public HttpConfiguration httpConfiguration() {
            return (HttpConfiguration)this.java.injector.instanceOf(HttpConfiguration.class);
        }

        public Future<?> stop() {
            return this.java.context.applicationLifecycle().asScala().stop();
        }

        public boolean globalApplicationEnabled() {
            return CdiLoader.safeConfigAccess(this.java.context.initialConfig(), "play.cdi.allowGlobalApplication", Config::getBoolean).orElse(false);
        }

        public File path() {
            return this.java.context.environment().rootPath();
        }

        public ClassLoader classloader() {
            return this.java.context.environment().classLoader();
        }

        public Mode mode() {
            return this.java.context.environment().mode().asScala();
        }

        public Environment environment() {
            return this.java.context.environment().asScala();
        }

        public boolean isDev() {
            return this.java.context.environment().isDev();
        }

        public boolean isTest() {
            return this.java.context.environment().isTest();
        }

        public boolean isProd() {
            return this.java.context.environment().isProd();
        }

        public Configuration configuration() {
            return new Configuration(this.java.context.initialConfig());
        }

        public play.Application asJava() {
            return this.java;
        }

        public File getFile(String relativePath) {
            return this.java.context.environment().getFile(relativePath);
        }

        public Option<File> getExistingFile(String relativePath) {
            return this.java.context.environment().asScala().getExistingFile(relativePath);
        }

        public Option<URL> resource(String name) {
            return this.java.context.environment().asScala().resource(name);
        }

        public Option<InputStream> resourceAsStream(String name) {
            return this.java.context.environment().asScala().resourceAsStream(name);
        }

        public play.api.inject.Injector injector() {
            return this.java.injector.asScala();
        }
    }

    private static class CdiScalaInjector
    implements play.api.inject.Injector {
        private final CdiInjector java;

        private CdiScalaInjector(CdiInjector cdiInjector) {
            this.java = cdiInjector;
        }

        public <T> T instanceOf(ClassTag<T> tag) {
            return this.java.instanceOf(tag.runtimeClass());
        }

        public <T> T instanceOf(Class<T> clazz) {
            return this.java.instanceOf(clazz);
        }

        public <T> T instanceOf(BindingKey<T> key) {
            return this.java.instanceOf(key);
        }

        public Injector asJava() {
            return this.java;
        }
    }

    private static class CdiInjector
    implements Injector {
        private final CdiScalaInjector scala = new CdiScalaInjector(this);
        private SeContainer container;

        private CdiInjector() {
        }

        public <T> T instanceOf(Class<T> clazz) {
            return (T)this.container.select(clazz, new Annotation[0]).get();
        }

        public <T> T instanceOf(BindingKey<T> key) {
            return (T)(key.qualifier().isEmpty() ? this.container.select(key.clazz(), new Annotation[0]) : this.container.select(key.clazz(), new Annotation[]{this.asQualifier((QualifierAnnotation)key.qualifier().get())})).get();
        }

        public play.api.inject.Injector asScala() {
            return this.scala;
        }

        private Annotation asQualifier(QualifierAnnotation qualifierAnnotation) {
            return QualifierInstance.class.isInstance(qualifierAnnotation) ? (Annotation)Annotation.class.cast(((QualifierInstance)QualifierInstance.class.cast(qualifierAnnotation)).instance()) : () -> ((QualifierClass)QualifierClass.class.cast(qualifierAnnotation)).clazz();
        }
    }
}

