/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.cdi2guice;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;

public class Cdi2GuiceModule
extends AbstractModule
implements AutoCloseable {
    private SeContainer container;
    private final Collection<Runnable> onClose = new ArrayList<Runnable>();
    private final GuiceContextAccessor accessor = new GuiceContextAccessor();

    protected void configure() {
        this.bind(GuiceContextAccessor.class).toInstance((Object)this.accessor);
        this.container = this.configuredContainer();
        this.onClose.add(() -> ((SeContainer)this.container).close());
    }

    public <T> T inject(T instance) {
        Class type = (Class)Class.class.cast(instance.getClass());
        BeanManager beanManager = this.container.getBeanManager();
        AnnotatedType annotatedType = beanManager.createAnnotatedType(type);
        InjectionTarget injectionTarget = beanManager.createInjectionTarget(annotatedType);
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        injectionTarget.inject(instance, creationalContext);
        injectionTarget.postConstruct(instance);
        this.onClose.add(() -> {
            injectionTarget.preDestroy(instance);
            injectionTarget.dispose(instance);
            creationalContext.release();
        });
        return instance;
    }

    @Override
    public void close() {
        this.onClose.forEach(this::doClose);
    }

    protected SeContainer configuredContainer() {
        SeContainerInitializer initializer = SeContainerInitializer.newInstance();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        initializer.setClassLoader(loader);
        initializer.addExtensions(new Extension[]{new Extension(){

            void addGuiceBeans(@Observes AfterBeanDiscovery afterBeanDiscovery) {
                afterBeanDiscovery.addBean().id(Cdi2GuiceModule.this.getClass().getName() + "#Injector").scope(Dependent.class).types(new Type[]{Injector.class, Object.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).createWith(c -> (Injector)Cdi2GuiceModule.this.accessor.getInjector().get());
            }
        }});
        Registrations registrations = Stream.of("", "/").map(prefix -> prefix + "META-INF/cdi2guice/container.properties").map(resource -> {
            try {
                return loader.getResources((String)resource);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).flatMap(urls -> Collections.list(urls).stream()).distinct().map(url -> {
            Properties properties = new Properties();
            try (InputStream stream = url.openStream();){
                properties.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return properties;
        }).sorted(Comparator.comparing(props -> Integer.parseInt(props.getProperty("configuration.order", "0")))).map(config -> {
            Class[] alternativeStereotypes;
            Class[] alternatives;
            Class[] interceptors;
            Class[] decorators;
            Class[] extensions;
            Class[] recursiveClassPackages;
            Class[] classPackages;
            Class[] classes = this.loadClasses(loader, config.getProperty("beanClasses", ""));
            if (classes.length > 0) {
                initializer.addBeanClasses(classes);
            }
            if ((classPackages = this.loadClasses(loader, config.getProperty("classPackages", ""))).length > 0) {
                initializer.addPackages(classPackages);
            }
            if ((recursiveClassPackages = this.loadClasses(loader, config.getProperty("recursiveClassPackages", ""))).length > 0) {
                initializer.addPackages(true, recursiveClassPackages);
            }
            if ((extensions = this.loadClasses(loader, config.getProperty("extensions", ""))).length > 0) {
                initializer.addExtensions(extensions);
            }
            if ((decorators = this.loadClasses(loader, config.getProperty("decorators", ""))).length > 0) {
                initializer.enableDecorators(decorators);
            }
            if ((interceptors = this.loadClasses(loader, config.getProperty("interceptors", ""))).length > 0) {
                initializer.enableInterceptors(interceptors);
            }
            if ((alternatives = this.loadClasses(loader, config.getProperty("alternatives", ""))).length > 0) {
                initializer.selectAlternatives(alternatives);
            }
            if ((alternativeStereotypes = this.loadClasses(loader, config.getProperty("alternativeStereotypes", ""))).length > 0) {
                initializer.selectAlternativeStereotypes(alternativeStereotypes);
            }
            if (Boolean.parseBoolean(config.getProperty("disableDiscovery", "false"))) {
                initializer.disableDiscovery();
            }
            Optional.ofNullable(config.getProperty("properties")).ifPresent(props -> {
                Properties properties = new Properties();
                try (StringReader reader = new StringReader((String)props);){
                    properties.load(reader);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                initializer.setProperties(properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), properties::getProperty)));
            });
            return new Registrations(config.getProperty("configuration.registeredBeans"), config.getProperty("configuration.excludedTypes"));
        }).filter(Objects::nonNull).reduce(new Registrations("true", null), (a, b) -> b);
        SeContainer initialize = initializer.initialize();
        if ("true".equalsIgnoreCase(registrations.includes) || registrations.includes != null && registrations.includes.contains("*")) {
            BeanManager beanManager = initialize.getBeanManager();
            Collection prefix2 = "true".equals(registrations.includes) ? null : (Collection)Stream.of(registrations.includes.split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(v -> v.endsWith("*") ? v.substring(0, v.length() - 1) : v).collect(Collectors.toList());
            initialize.getBeanManager().getBeans(Object.class, new Annotation[0]).forEach(bean -> this.register(registrations.excludes, bean.getTypes().stream().filter(it -> {
                boolean isPt = ParameterizedType.class.isInstance(it);
                if (isPt) {
                    ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(it);
                    return this.isIncluded(prefix2, pt.getRawType());
                }
                return this.isIncluded(prefix2, (Type)it);
            }).collect(Collectors.toList()), bean.getQualifiers().stream().filter(q -> Default.class != q.annotationType() && Any.class != q.annotationType()).collect(Collectors.toList()), type -> {
                CreationalContext creationalContext = beanManager.createCreationalContext(null);
                Object reference = beanManager.getReference(bean, type, creationalContext);
                if (!beanManager.isNormalScope(bean.getScope())) {
                    creationalContext.release();
                }
                return reference;
            }));
        } else if (registrations.includes != null) {
            Stream.of(this.loadClasses(loader, registrations.includes)).forEach(clazz -> this.register(registrations.excludes, Collections.singletonList(clazz), Collections.emptyList(), type -> initialize.select(clazz, new Annotation[0]).get()));
        }
        return initialize;
    }

    private boolean isIncluded(Collection<String> prefix, Type it) {
        String typeName = it.getTypeName();
        return prefix == null && this.filterByClass(it) || prefix != null && prefix.stream().anyMatch(p -> typeName.startsWith((String)p));
    }

    private boolean filterByClass(Type it) {
        if (it == Principal.class) {
            return false;
        }
        if (it == Instance.class) {
            return false;
        }
        if (it == javax.inject.Provider.class) {
            return false;
        }
        if (it == EventMetadata.class) {
            return false;
        }
        if (it == InjectionPoint.class) {
            return false;
        }
        if (it == Bean.class) {
            return false;
        }
        if (it == Contextual.class) {
            return false;
        }
        if (it == Event.class) {
            return false;
        }
        if (it == Object.class) {
            return false;
        }
        if (it == Conversation.class) {
            return false;
        }
        if (it == Extension.class) {
            return false;
        }
        if (Class.class.isInstance(it)) {
            Class clazz = (Class)Class.class.cast(it);
            return !Modifier.isAbstract(clazz.getModifiers());
        }
        return true;
    }

    private void register(Collection<String> excludes, Collection<Type> types, Collection<Annotation> bindingAnnotations, Function<Type, Object> provider) {
        types.stream().filter(it -> !bindingAnnotations.isEmpty() || !it.getTypeName().startsWith("java.")).filter(it -> excludes == null || excludes.stream().noneMatch(v -> it.getTypeName().startsWith((String)v))).forEach(type -> {
            TypeLiteral typeLiteral = TypeLiteral.get((Type)type);
            if (bindingAnnotations.isEmpty()) {
                this.bind(typeLiteral).toProvider(() -> provider.apply((Type)type));
            } else {
                bindingAnnotations.forEach(binding -> this.bind(typeLiteral).annotatedWith(binding).toProvider(() -> provider.apply((Type)type)));
            }
        });
    }

    private Class[] loadClasses(ClassLoader loader, String value) {
        return (Class[])Stream.of(value.split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(it -> {
            try {
                return loader.loadClass((String)it);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }).toArray(Class[]::new);
    }

    protected void doClose(Runnable runnable) {
        runnable.run();
    }

    private static class Registrations {
        private final String includes;
        private final Collection<String> excludes;

        private Registrations(String includes, String excludes) {
            this.includes = includes;
            this.excludes = excludes == null ? null : (Collection)Stream.of(excludes.split(",")).map(String::trim).filter(it -> !it.isEmpty()).collect(Collectors.toSet());
        }
    }

    @Vetoed
    public static class GuiceContextAccessor {
        @Inject
        private Provider<Injector> injector;

        public Provider<Injector> getInjector() {
            return this.injector;
        }
    }
}

