/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.xlsx.CloseableIterator;
import com.github.pjfanning.xlsx.SharedFormula;
import com.github.pjfanning.xlsx.impl.StreamingSheetReader;
import com.github.pjfanning.xlsx.impl.WrappedComment;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import org.apache.poi.ss.usermodel.AutoFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.usermodel.XSSFComment;

public class StreamingSheet
implements Sheet {
    private final String name;
    private final StreamingSheetReader reader;

    public StreamingSheet(String name, StreamingSheetReader reader) {
        this.name = name;
        this.reader = reader;
        reader.setSheet(this);
    }

    StreamingSheetReader getReader() {
        return this.reader;
    }

    public Workbook getWorkbook() {
        return this.reader.getWorkbook();
    }

    public CloseableIterator<Row> iterator() {
        return this.reader.iterator();
    }

    public CloseableIterator<Row> rowIterator() {
        return this.reader.iterator();
    }

    public Spliterator<Row> spliterator() {
        return Spliterators.spliterator(this.rowIterator(), Long.MAX_VALUE, 16);
    }

    public String getSheetName() {
        return this.name;
    }

    public boolean isColumnHidden(int columnIndex) {
        return this.reader.isColumnHidden(columnIndex);
    }

    public int getFirstRowNum() {
        return this.reader.getFirstRowNum();
    }

    public int getLastRowNum() {
        return this.reader.getLastRowNum();
    }

    public Comment getCellComment(CellAddress cellAddress) {
        Comments sheetComments = this.reader.getCellComments();
        if (sheetComments == null) {
            return null;
        }
        XSSFComment xssfComment = sheetComments.findCellComment(cellAddress);
        if (xssfComment != null && this.reader.getBuilder().adjustLegacyComments()) {
            return new WrappedComment(xssfComment);
        }
        return xssfComment;
    }

    public Map<CellAddress, ? extends Comment> getCellComments() {
        Comments sheetComments = this.reader.getCellComments();
        if (sheetComments == null) {
            return Collections.emptyMap();
        }
        HashMap<CellAddress, Comment> map = new HashMap<CellAddress, Comment>();
        Iterator iter = sheetComments.getCellAddresses();
        while (iter.hasNext()) {
            CellAddress address = (CellAddress)iter.next();
            map.put(address, this.getCellComment(address));
        }
        return map;
    }

    public CellRangeAddress getMergedRegion(int index) {
        List<CellRangeAddress> regions = this.getMergedRegions();
        if (index > regions.size()) {
            throw new NoSuchElementException("index " + index + " is out of range");
        }
        return regions.get(index);
    }

    public List<CellRangeAddress> getMergedRegions() {
        return this.reader.getMergedCells();
    }

    public int getNumMergedRegions() {
        List<CellRangeAddress> mergedCells = this.reader.getMergedCells();
        return mergedCells == null ? 0 : mergedCells.size();
    }

    public Drawing<?> getDrawingPatriarch() {
        return this.reader.getDrawingPatriarch();
    }

    public Hyperlink getHyperlink(int row, int column) {
        return this.getHyperlink(new CellAddress(row, column));
    }

    public Hyperlink getHyperlink(CellAddress cellAddress) {
        for (Hyperlink hyperlink : this.getHyperlinkList()) {
            if (cellAddress.getRow() < hyperlink.getFirstRow() || cellAddress.getRow() > hyperlink.getLastRow() || cellAddress.getColumn() < hyperlink.getFirstColumn() || cellAddress.getColumn() > hyperlink.getLastColumn()) continue;
            return hyperlink;
        }
        return null;
    }

    public List<? extends Hyperlink> getHyperlinkList() {
        return this.reader.getHyperlinks();
    }

    public CellAddress getActiveCell() {
        return this.reader.getActiveCell();
    }

    public int getDefaultColumnWidth() {
        return this.reader.getBaseColWidth();
    }

    public short getDefaultRowHeight() {
        return (short)(this.getDefaultRowHeightInPoints() * 20.0f);
    }

    public float getDefaultRowHeightInPoints() {
        return this.reader.getDefaultRowHeight();
    }

    public int getColumnWidth(int columnIndex) {
        return Math.round(this.reader.getColumnWidth(columnIndex) * 256.0f);
    }

    public float getColumnWidthInPixels(int columnIndex) {
        float widthIn256 = this.getColumnWidth(columnIndex);
        return (float)((double)widthIn256 / 256.0 * (double)7.0017f);
    }

    public PaneInformation getPaneInformation() {
        return this.reader.getPane();
    }

    public Map<String, SharedFormula> getSharedFormulaMap() {
        return this.reader.getSharedFormulaMap();
    }

    public void addSharedFormula(String siValue, SharedFormula sharedFormula) {
        this.reader.addSharedFormula(siValue, sharedFormula);
    }

    public SharedFormula removeSharedFormula(String siValue) {
        return this.reader.removeSharedFormula(siValue);
    }

    public Row createRow(int rownum) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void removeRow(Row row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public Row getRow(int rownum) {
        throw new UnsupportedOperationException("use iterator() or rowIterator() instead");
    }

    public int getPhysicalNumberOfRows() {
        throw new UnsupportedOperationException();
    }

    public void setColumnHidden(int columnIndex, boolean hidden) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setRightToLeft(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean isRightToLeft() {
        throw new UnsupportedOperationException();
    }

    public void setColumnWidth(int columnIndex, int width) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setDefaultColumnWidth(int width) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setDefaultRowHeight(short height) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setDefaultRowHeightInPoints(float height) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public CellStyle getColumnStyle(int column) {
        throw new UnsupportedOperationException();
    }

    public int addMergedRegion(CellRangeAddress region) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public int addMergedRegionUnsafe(CellRangeAddress cellRangeAddress) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void validateMergedRegions() {
        throw new UnsupportedOperationException();
    }

    public void setVerticallyCenter(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setHorizontallyCenter(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean getHorizontallyCenter() {
        throw new UnsupportedOperationException();
    }

    public boolean getVerticallyCenter() {
        throw new UnsupportedOperationException();
    }

    public void removeMergedRegion(int index) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void removeMergedRegions(Collection<Integer> collection) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setForceFormulaRecalculation(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean getForceFormulaRecalculation() {
        throw new UnsupportedOperationException();
    }

    public void setAutobreaks(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setDisplayGuts(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setDisplayZeros(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean isDisplayZeros() {
        throw new UnsupportedOperationException();
    }

    public void setFitToPage(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setRowSumsBelow(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setRowSumsRight(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean getAutobreaks() {
        throw new UnsupportedOperationException();
    }

    public boolean getDisplayGuts() {
        throw new UnsupportedOperationException();
    }

    public boolean getFitToPage() {
        throw new UnsupportedOperationException();
    }

    public boolean getRowSumsBelow() {
        throw new UnsupportedOperationException();
    }

    public boolean getRowSumsRight() {
        throw new UnsupportedOperationException();
    }

    public boolean isPrintGridlines() {
        throw new UnsupportedOperationException();
    }

    public void setPrintGridlines(boolean show) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean isPrintRowAndColumnHeadings() {
        throw new UnsupportedOperationException();
    }

    public void setPrintRowAndColumnHeadings(boolean b) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public PrintSetup getPrintSetup() {
        throw new UnsupportedOperationException();
    }

    public Header getHeader() {
        throw new UnsupportedOperationException();
    }

    public Footer getFooter() {
        throw new UnsupportedOperationException();
    }

    public void setSelected(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public double getMargin(short margin) {
        throw new UnsupportedOperationException();
    }

    public void setMargin(short margin, double size) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean getProtect() {
        throw new UnsupportedOperationException();
    }

    public void protectSheet(String password) {
        throw new UnsupportedOperationException();
    }

    public boolean getScenarioProtect() {
        throw new UnsupportedOperationException();
    }

    public void setZoom(int i) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public short getTopRow() {
        throw new UnsupportedOperationException();
    }

    public short getLeftCol() {
        throw new UnsupportedOperationException();
    }

    public void showInPane(int toprow, int leftcol) {
        throw new UnsupportedOperationException();
    }

    public void shiftRows(int startRow, int endRow, int n) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void shiftColumns(int startColumn, int endColumn, int n) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        throw new UnsupportedOperationException();
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        throw new UnsupportedOperationException();
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        throw new UnsupportedOperationException();
    }

    public void setDisplayGridlines(boolean show) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean isDisplayGridlines() {
        throw new UnsupportedOperationException();
    }

    public void setDisplayFormulas(boolean show) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean isDisplayFormulas() {
        throw new UnsupportedOperationException();
    }

    public void setDisplayRowColHeadings(boolean show) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean isDisplayRowColHeadings() {
        throw new UnsupportedOperationException();
    }

    public void setRowBreak(int row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean isRowBroken(int row) {
        throw new UnsupportedOperationException();
    }

    public void removeRowBreak(int row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public int[] getRowBreaks() {
        throw new UnsupportedOperationException();
    }

    public int[] getColumnBreaks() {
        throw new UnsupportedOperationException();
    }

    public void setColumnBreak(int column) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean isColumnBroken(int column) {
        throw new UnsupportedOperationException();
    }

    public void removeColumnBreak(int column) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void groupColumn(int fromColumn, int toColumn) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void ungroupColumn(int fromColumn, int toColumn) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void groupRow(int fromRow, int toRow) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void ungroupRow(int fromRow, int toRow) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setRowGroupCollapsed(int row, boolean collapse) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setDefaultColumnStyle(int column, CellStyle style) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void autoSizeColumn(int column) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void autoSizeColumn(int column, boolean useMergedCells) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public Drawing createDrawingPatriarch() {
        throw new UnsupportedOperationException();
    }

    public boolean isSelected() {
        throw new UnsupportedOperationException();
    }

    public CellRange<? extends Cell> setArrayFormula(String formula, CellRangeAddress range) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public CellRange<? extends Cell> removeArrayFormula(Cell cell) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public DataValidationHelper getDataValidationHelper() {
        throw new UnsupportedOperationException();
    }

    public List<? extends DataValidation> getDataValidations() {
        throw new UnsupportedOperationException();
    }

    public void addValidationData(DataValidation dataValidation) {
        throw new UnsupportedOperationException();
    }

    public AutoFilter setAutoFilter(CellRangeAddress range) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public SheetConditionalFormatting getSheetConditionalFormatting() {
        throw new UnsupportedOperationException();
    }

    public CellRangeAddress getRepeatingRows() {
        throw new UnsupportedOperationException();
    }

    public CellRangeAddress getRepeatingColumns() {
        throw new UnsupportedOperationException();
    }

    public void setRepeatingRows(CellRangeAddress rowRangeRef) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setRepeatingColumns(CellRangeAddress columnRangeRef) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public int getColumnOutlineLevel(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public void setActiveCell(CellAddress cellAddress) {
        throw new UnsupportedOperationException("update operations are not supported");
    }
}

