/*
 * Decompiled with CFR 0.152.
 */
package com.github.picadoh.imc.model;

import com.google.common.base.Objects;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class JavaSourceFromString
extends SimpleJavaFileObject {
    private final String code;
    private final String className;

    public JavaSourceFromString(String className) {
        super(URI.create("mem:///" + className.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
        this.className = className;
        this.code = null;
    }

    public JavaSourceFromString(String className, String javaSourceCode) {
        super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
        this.className = className;
        this.code = javaSourceCode;
    }

    @Override
    public final CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.code;
    }

    @Override
    public final String getName() {
        return this.className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaSourceFromString that = (JavaSourceFromString)o;
        return Objects.equal((Object)this.code, (Object)that.code) && Objects.equal((Object)this.className, (Object)that.className);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.code, this.className});
    }
}

