/*
 * Decompiled with CFR 0.152.
 */
package com.github.picadoh.imc.loader;

import com.github.picadoh.imc.loader.ByteArrayClassLoader;
import com.github.picadoh.imc.model.CompilationPackage;
import com.github.picadoh.imc.model.CompilationUnit;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CompilationPackageLoader {
    private static final Function<Class, String> BY_CLASS_NAME = new Function<Class, String>(){

        public String apply(Class aClass) {
            return aClass.getName();
        }
    };

    public List<Class<?>> load(CompilationPackage pkg) throws ClassNotFoundException {
        ByteArrayClassLoader bacl = this.newByteArrayClassLoader();
        ArrayList loadedClasses = Lists.newArrayList();
        for (CompilationUnit unit : pkg.getUnits()) {
            Class cls = bacl.loadClass(unit.getName(), unit.getBytecode());
            loadedClasses.add(cls);
        }
        return loadedClasses;
    }

    public Map<String, Class<?>> loadAsMap(CompilationPackage pkg) throws ClassNotFoundException {
        List<Class<?>> classes = this.load(pkg);
        return Maps.uniqueIndex(classes, BY_CLASS_NAME);
    }

    @VisibleForTesting
    ByteArrayClassLoader newByteArrayClassLoader() {
        return ByteArrayClassLoader.newInstance();
    }
}

