/*
 * Decompiled with CFR 0.152.
 */
package com.github.picadoh.imc.loader;

import com.google.common.annotations.VisibleForTesting;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ByteArrayClassLoader
extends ClassLoader {
    private byte[] bytecode;

    private ByteArrayClassLoader() {
        super(ByteArrayClassLoader.class.getClassLoader());
    }

    public Class loadClass(String fqdn, byte[] byteCode) throws ClassNotFoundException {
        this.setBytecode((byte[])byteCode.clone());
        return this.loadClass(fqdn);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> cls = null;
        try {
            if (this.bytecode != null) {
                cls = this.defineClass(name, this.bytecode);
            }
        }
        catch (ClassFormatError ex) {
            throw new ClassNotFoundException("Class name: " + name, ex);
        }
        return cls;
    }

    public static ByteArrayClassLoader newInstance() {
        return AccessController.doPrivileged(new BaclPrevilegedAction());
    }

    @VisibleForTesting
    Class<?> defineClass(String name, byte[] bytecode) {
        return this.defineClass(name, bytecode, 0, bytecode.length);
    }

    @VisibleForTesting
    void setBytecode(byte[] bytecode) {
        this.bytecode = bytecode;
    }

    @VisibleForTesting
    byte[] getBytecode() {
        return this.bytecode;
    }

    private static class BaclPrevilegedAction
    implements PrivilegedAction<ByteArrayClassLoader> {
        private BaclPrevilegedAction() {
        }

        @Override
        public ByteArrayClassLoader run() {
            return new ByteArrayClassLoader();
        }
    }
}

