/*
 * Decompiled with CFR 0.152.
 */
package com.github.picadoh.imc.compiler;

import com.github.picadoh.imc.compiler.InMemoryClassManager;
import com.github.picadoh.imc.model.CompilationPackage;
import com.github.picadoh.imc.model.CompilationUnit;
import com.github.picadoh.imc.model.JavaSourceFromString;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class InMemoryCompiler {
    public CompilationPackage singleCompile(String className, String code) throws CompilerException {
        return this.compile((Map<String, String>)ImmutableMap.builder().put((Object)className, (Object)code).build());
    }

    public CompilationPackage compile(Map<String, String> classesToCompile) throws CompilerException {
        JavaCompiler compiler = this.getSystemJavaCompiler();
        DiagnosticCollector<JavaFileObject> collector = this.getDiagnosticCollector();
        InMemoryClassManager manager = this.getClassManager(compiler);
        String classpath = this.loadClasspath();
        List<String> options = Arrays.asList("-classpath", classpath);
        ArrayList strFiles = Lists.newArrayList();
        for (String className : classesToCompile.keySet()) {
            String classCode = classesToCompile.get(className);
            strFiles.add(new JavaSourceFromString(className, classCode));
        }
        JavaCompiler.CompilationTask task = compiler.getTask(null, manager, collector, options, null, strFiles);
        boolean status = task.call();
        if (status) {
            List<CompilationUnit> compilationUnits = manager.getAllClasses();
            return new CompilationPackage(compilationUnits);
        }
        String compilationReport = this.buildCompilationReport(collector, options);
        throw new CompilerException(compilationReport);
    }

    @VisibleForTesting
    DiagnosticCollector<JavaFileObject> getDiagnosticCollector() {
        return new DiagnosticCollector<JavaFileObject>();
    }

    @VisibleForTesting
    InMemoryClassManager getClassManager(JavaCompiler compiler) {
        return new InMemoryClassManager(compiler.getStandardFileManager(null, null, null));
    }

    @VisibleForTesting
    JavaCompiler getSystemJavaCompiler() {
        return ToolProvider.getSystemJavaCompiler();
    }

    @VisibleForTesting
    String buildCompilationReport(DiagnosticCollector<JavaFileObject> collector, List<String> options) {
        int count = 0;
        StringBuilder resultBuilder = new StringBuilder();
        for (Diagnostic<JavaFileObject> diagnostic : collector.getDiagnostics()) {
            ++count;
            JavaSourceFromString javaSource = (JavaSourceFromString)diagnostic.getSource();
            resultBuilder.append(javaSource.getCharContent(false)).append("\n");
            resultBuilder.append("Compiler options: ").append(options).append("\n\n");
            resultBuilder.append((Object)diagnostic.getKind()).append("|").append(diagnostic.getCode()).append("\n");
            resultBuilder.append("LINE:COLUMN ").append(diagnostic.getLineNumber()).append(":").append(diagnostic.getColumnNumber()).append("\n").append(diagnostic.getMessage(null)).append("\n\n");
        }
        String diagnosticString = resultBuilder.toString();
        String compilationErrorsOverview = String.valueOf(count) + " class(es) failed to compile";
        return "Compilation error\n" + compilationErrorsOverview + "\n" + diagnosticString;
    }

    @VisibleForTesting
    String loadClasspath() {
        StringBuilder sb = new StringBuilder();
        URLClassLoader urlClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        for (URL url : urlClassLoader.getURLs()) {
            sb.append(url.getFile()).append(System.getProperty("path.separator"));
        }
        return sb.toString();
    }

    public static class CompilerException
    extends Exception {
        public CompilerException(String message) {
            super(message);
        }
    }
}

