/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.bind.mapping.HSSFUnmarshaller;
import com.poiji.exception.PoijiException;
import com.poiji.option.PoijiOptions;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class SheetUnmarshaller
extends HSSFUnmarshaller {
    private Sheet sheet;

    SheetUnmarshaller(Sheet sheet, PoijiOptions options) {
        super(options);
        this.sheet = sheet;
    }

    @Override
    public <T> void unmarshal(Class<T> type, Consumer<? super T> consumer) {
        Workbook workbook = this.workbook();
        if (workbook instanceof HSSFWorkbook) {
            this.baseFormulaEvaluator = HSSFFormulaEvaluator.create((HSSFWorkbook)((HSSFWorkbook)workbook), null, null);
        } else if (workbook instanceof XSSFWorkbook) {
            this.baseFormulaEvaluator = XSSFFormulaEvaluator.create((XSSFWorkbook)((XSSFWorkbook)workbook), null, null);
        } else {
            throw new PoijiException("Workbook is not supported.");
        }
        this.processRowsToObjects(this.sheet, type, consumer);
    }

    @Override
    public <T> Optional<String> getSheetName(Class<T> type, PoijiOptions options) {
        return Optional.empty();
    }

    @Override
    protected Workbook workbook() {
        return this.sheet.getWorkbook();
    }
}

