/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protocjar.maven;

import com.github.os72.protocjar.PlatformDetector;
import com.github.os72.protocjar.Protoc;
import com.github.os72.protocjar.ProtocVersion;
import com.github.os72.protocjar.maven.OutputTarget;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocJarMojo
extends AbstractMojo {
    private static final String DEFAULT_INPUT_DIR = "/src/main/protobuf/".replace('/', File.separatorChar);
    private String protocVersion;
    private boolean optimizeCodegen;
    private File[] inputDirectories;
    private File[] includeDirectories;
    private boolean includeStdTypes;
    private String includeMavenTypes;
    private String compileMavenTypes;
    private String addProtoSources;
    private String type;
    private String addSources;
    private boolean includeImports;
    private boolean cleanOutputFolder;
    private String pluginPath;
    private String pluginArtifact;
    private File outputDirectory;
    private String outputDirectorySuffix;
    private String outputOptions;
    private OutputTarget[] outputTargets;
    private String extension;
    private String protocCommand;
    private String protocArtifact;
    private MavenProject project;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private BuildContext buildContext;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    protected MavenProjectHelper projectHelper;
    private File tempRoot = null;

    public void execute() throws MojoExecutionException {
        if (this.project.getPackaging() != null && "pom".equals(this.project.getPackaging().toLowerCase())) {
            this.getLog().info((CharSequence)"Skipping 'pom' packaged project");
            return;
        }
        if (this.outputTargets == null || this.outputTargets.length == 0) {
            OutputTarget target = new OutputTarget();
            target.type = this.type;
            target.addSources = this.addSources;
            target.cleanOutputFolder = this.cleanOutputFolder;
            target.pluginPath = this.pluginPath;
            target.pluginArtifact = this.pluginArtifact;
            target.outputDirectory = this.outputDirectory;
            target.outputDirectorySuffix = this.outputDirectorySuffix;
            target.outputOptions = this.outputOptions;
            this.outputTargets = new OutputTarget[]{target};
        }
        boolean missingOutputDirectory = false;
        for (OutputTarget target : this.outputTargets) {
            String[] outputFiles;
            target.addSources = target.addSources.toLowerCase().trim();
            if ("true".equals(target.addSources)) {
                target.addSources = "main";
            }
            if (target.outputDirectory == null) {
                String subdir = "generated-" + ("test".equals(target.addSources) ? "test-" : "") + "sources";
                target.outputDirectory = new File(this.project.getBuild().getDirectory() + File.separator + subdir + File.separator);
            }
            if (target.outputDirectorySuffix != null) {
                target.outputDirectory = new File(target.outputDirectory, target.outputDirectorySuffix);
            }
            if ((outputFiles = target.outputDirectory.list()) != null && outputFiles.length != 0) continue;
            missingOutputDirectory = true;
        }
        if (!this.optimizeCodegen) {
            this.performProtoCompilation(true);
            return;
        }
        File successFile = new File(this.project.getBuild().getDirectory(), "pjmp-success.txt");
        try {
            long oldestOutputFileTime = ProtocJarMojo.minFileTime(this.outputTargets);
            long newestInputFileTime = ProtocJarMojo.maxFileTime(this.inputDirectories);
            if (successFile.exists() && newestInputFileTime < oldestOutputFileTime && !missingOutputDirectory) {
                this.getLog().info((CharSequence)"Skipping code generation, proto files appear unchanged since last compilation");
                this.performProtoCompilation(false);
                return;
            }
            successFile.delete();
            this.performProtoCompilation(true);
            successFile.getParentFile().mkdirs();
            successFile.createNewFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("File operation failed: " + successFile, (Exception)e);
        }
    }

    private void performProtoCompilation(boolean doCodegen) throws MojoExecutionException {
        ArrayList excs;
        List<String> incs;
        if (doCodegen) {
            this.prepareProtoc();
        }
        File tmpDir = ProtocJarMojo.createTempDir("protocjar");
        if (this.includeStdTypes || this.hasIncludeMavenTypes()) {
            try {
                File extraTypeDir = new File(tmpDir, "include");
                extraTypeDir.mkdir();
                this.getLog().info((CharSequence)("Additional include types: " + extraTypeDir));
                this.addIncludeDir(extraTypeDir);
                if (this.includeStdTypes) {
                    Protoc.extractStdTypes(ProtocVersion.getVersion("-v" + this.protocVersion), tmpDir);
                }
                if (this.hasIncludeMavenTypes()) {
                    this.extractProtosFromDependencies(extraTypeDir, this.includeMavenTypes.equalsIgnoreCase("transitive"));
                }
                ProtocJarMojo.deleteOnExitRecursive(extraTypeDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error extracting additional include types", (Exception)e);
            }
        }
        if (this.inputDirectories == null || this.inputDirectories.length == 0) {
            File inputDir = new File(this.project.getBasedir().getAbsolutePath() + DEFAULT_INPUT_DIR);
            this.inputDirectories = new File[]{inputDir};
        }
        if (this.hasCompileMavenTypes()) {
            try {
                File mavenTypesCompileDir = new File(tmpDir, "mvncompile");
                mavenTypesCompileDir.mkdir();
                this.getLog().info((CharSequence)("Files to compile from Maven dependencies (" + this.compileMavenTypes + "): " + mavenTypesCompileDir));
                this.addInputDir(mavenTypesCompileDir);
                this.extractProtosFromDependencies(mavenTypesCompileDir, this.compileMavenTypes.equalsIgnoreCase("transitive"));
                ProtocJarMojo.deleteOnExitRecursive(mavenTypesCompileDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error extracting files from Maven dependencies", (Exception)e);
            }
        }
        this.getLog().info((CharSequence)"Input directories:");
        for (File file : this.inputDirectories) {
            this.getLog().info((CharSequence)("    " + file));
            if (!"all".equalsIgnoreCase(this.addProtoSources) && !"inputs".equalsIgnoreCase(this.addProtoSources)) continue;
            incs = Arrays.asList("**/*" + this.extension);
            excs = new ArrayList();
            this.projectHelper.addResource(this.project, file.getAbsolutePath(), incs, excs);
        }
        if (this.includeDirectories != null && this.includeDirectories.length > 0) {
            this.getLog().info((CharSequence)"Include directories:");
            for (File file : this.includeDirectories) {
                this.getLog().info((CharSequence)("    " + file));
                if (!"all".equalsIgnoreCase(this.addProtoSources)) continue;
                incs = Arrays.asList("**/*" + this.extension);
                excs = new ArrayList();
                this.projectHelper.addResource(this.project, file.getAbsolutePath(), incs, excs);
            }
        }
        if (doCodegen) {
            this.getLog().info((CharSequence)"Output targets:");
            for (OutputTarget outputTarget : this.outputTargets) {
                this.getLog().info((CharSequence)("    " + outputTarget));
            }
            for (OutputTarget outputTarget : this.outputTargets) {
                this.preprocessTarget(outputTarget);
            }
            for (OutputTarget outputTarget : this.outputTargets) {
                this.processTarget(outputTarget);
            }
        }
        for (OutputTarget outputTarget : this.outputTargets) {
            this.addGeneratedSources(outputTarget);
        }
    }

    private void prepareProtoc() throws MojoExecutionException {
        if (this.protocCommand != null) {
            try {
                Protoc.runProtoc(this.protocCommand, new String[]{"--version"});
            }
            catch (Exception e) {
                this.protocCommand = null;
            }
        }
        if (this.protocCommand == null && this.protocArtifact == null) {
            if (ProtocJarMojo.isEmpty(this.protocVersion)) {
                this.protocVersion = ProtocVersion.PROTOC_VERSION.mVersion;
            }
            this.getLog().info((CharSequence)("Protoc version: " + this.protocVersion));
            try {
                if (this.protocCommand == null && this.protocArtifact == null) {
                    File protocFile = Protoc.extractProtoc(ProtocVersion.getVersion("-v" + this.protocVersion), false);
                    this.protocCommand = protocFile.getAbsolutePath();
                    try {
                        Protoc.runProtoc(this.protocCommand, new String[]{"--version"});
                    }
                    catch (Exception e) {
                        this.tempRoot = new File(System.getProperty("user.home"));
                        protocFile = Protoc.extractProtoc(ProtocVersion.getVersion("-v" + this.protocVersion), false, this.tempRoot);
                        this.protocCommand = protocFile.getAbsolutePath();
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error extracting protoc for version " + this.protocVersion, (Exception)e);
            }
        }
        if (this.protocCommand == null && this.protocArtifact != null) {
            this.protocVersion = ProtocVersion.getVersion((String)new StringBuilder().append((String)"-v:").append((String)this.protocArtifact).toString()).mVersion;
            this.protocCommand = this.resolveArtifact(this.protocArtifact, null).getAbsolutePath();
            try {
                Protoc.runProtoc(this.protocCommand, new String[]{"--version"});
            }
            catch (Exception e) {
                this.tempRoot = new File(System.getProperty("user.home"));
                this.protocCommand = this.resolveArtifact(this.protocArtifact, this.tempRoot).getAbsolutePath();
            }
        }
        this.getLog().info((CharSequence)("Protoc command: " + this.protocCommand));
    }

    private void addIncludeDir(File dir) {
        this.includeDirectories = ProtocJarMojo.addDir(this.includeDirectories, dir);
    }

    private void addInputDir(File dir) {
        this.inputDirectories = ProtocJarMojo.addDir(this.inputDirectories, dir);
    }

    private boolean hasIncludeMavenTypes() {
        return this.includeMavenTypes.equalsIgnoreCase("direct") || this.includeMavenTypes.equalsIgnoreCase("transitive");
    }

    private boolean hasCompileMavenTypes() {
        return this.compileMavenTypes.equalsIgnoreCase("direct") || this.compileMavenTypes.equalsIgnoreCase("transitive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractProtosFromDependencies(File dir, boolean transitive) throws IOException {
        for (Artifact artifact : this.getArtifactsForProtoExtraction(transitive)) {
            if (artifact.getFile() == null) continue;
            this.getLog().debug((CharSequence)("  Scanning artifact: " + artifact.getFile()));
            InputStream is = null;
            try {
                ZipEntry ze;
                if (artifact.getFile().isDirectory()) {
                    for (File f : this.listFilesRecursively(artifact.getFile(), this.extension, new ArrayList<File>())) {
                        is = new FileInputStream(f);
                        String name = f.getAbsolutePath().replace(artifact.getFile().getAbsolutePath(), "");
                        if (name.startsWith("/")) {
                            name = name.substring(1);
                        }
                        this.writeProtoFile(dir, is, name);
                        is.close();
                    }
                    continue;
                }
                ZipInputStream zis = new ZipInputStream(new FileInputStream(artifact.getFile()));
                is = zis;
                while ((ze = zis.getNextEntry()) != null) {
                    if (ze.isDirectory() || !ze.getName().toLowerCase().endsWith(this.extension)) continue;
                    this.writeProtoFile(dir, zis, ze.getName());
                    zis.closeEntry();
                }
            }
            catch (IOException e) {
                this.getLog().info((CharSequence)("  Error scanning artifact: " + artifact.getFile() + ": " + e));
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private Set<Artifact> getArtifactsForProtoExtraction(boolean transitive) {
        if (transitive) {
            return this.project.getArtifacts();
        }
        return this.project.getDependencyArtifacts();
    }

    private List<File> listFilesRecursively(File directory, String ext, List<File> list) {
        for (File f : directory.listFiles()) {
            if (f.isFile() && f.canRead() && f.getName().toLowerCase().endsWith(ext)) {
                list.add(f);
                continue;
            }
            if (!f.isDirectory() || !f.canExecute()) continue;
            this.listFilesRecursively(f, ext, list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProtoFile(File dir, InputStream zis, String name) throws IOException {
        this.getLog().info((CharSequence)("    " + name));
        File protoOut = new File(dir, name);
        protoOut.getParentFile().mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(protoOut);
            ProtocJarMojo.streamCopy(zis, fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void preprocessTarget(OutputTarget target) throws MojoExecutionException {
        File f;
        if (!ProtocJarMojo.isEmpty(target.pluginArtifact)) {
            target.pluginPath = this.resolveArtifact(target.pluginArtifact, this.tempRoot).getAbsolutePath();
        }
        if (!(f = target.outputDirectory).exists()) {
            this.getLog().info((CharSequence)(f + " does not exist. Creating..."));
            f.mkdirs();
        }
        if (target.cleanOutputFolder) {
            try {
                this.getLog().info((CharSequence)("Cleaning " + f));
                FileUtils.cleanDirectory((File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void processTarget(OutputTarget target) throws MojoExecutionException {
        boolean shaded = false;
        String targetType = target.type;
        if (targetType.equals("java-shaded") || targetType.equals("java_shaded")) {
            targetType = "java";
            shaded = true;
        }
        FileFilter fileFilter = new FileFilter(this.extension);
        for (File input : this.inputDirectories) {
            if (input == null) continue;
            if (input.exists() && input.isDirectory()) {
                Collection protoFiles = FileUtils.listFiles((File)input, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
                for (File protoFile : protoFiles) {
                    if (target.cleanOutputFolder || this.buildContext.hasDelta(protoFile.getPath())) {
                        this.processFile(protoFile, this.protocVersion, targetType, target.pluginPath, target.outputDirectory, target.outputOptions);
                        continue;
                    }
                    this.getLog().info((CharSequence)("Not changed " + protoFile));
                }
                continue;
            }
            if (input.exists()) {
                this.getLog().warn((CharSequence)(input + " is not a directory"));
                continue;
            }
            this.getLog().warn((CharSequence)(input + " does not exist"));
        }
        if (shaded) {
            try {
                this.getLog().info((CharSequence)("    Shading (version " + this.protocVersion + "): " + target.outputDirectory));
                Protoc.doShading(target.outputDirectory, this.protocVersion);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error occurred during shading", (Exception)e);
            }
        }
    }

    private void addGeneratedSources(OutputTarget target) throws MojoExecutionException {
        boolean mainAddSources = "main".endsWith(target.addSources);
        boolean testAddSources = "test".endsWith(target.addSources);
        if (mainAddSources) {
            this.getLog().info((CharSequence)("Adding generated sources (" + target.type + "): " + target.outputDirectory));
            this.project.addCompileSourceRoot(target.outputDirectory.getAbsolutePath());
        }
        if (testAddSources) {
            this.getLog().info((CharSequence)("Adding generated test sources (" + target.type + "): " + target.outputDirectory));
            this.project.addTestCompileSourceRoot(target.outputDirectory.getAbsolutePath());
        }
        if (mainAddSources || testAddSources) {
            this.buildContext.refresh(target.outputDirectory);
        }
    }

    private void processFile(File file, String version, String type, String pluginPath, File outputDir, String outputOptions) throws MojoExecutionException {
        this.getLog().info((CharSequence)("    Processing (" + type + "): " + file.getName()));
        try {
            this.buildContext.removeMessages(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            TeeOutputStream outTee = new TeeOutputStream((OutputStream)System.out, (OutputStream)out);
            TeeOutputStream errTee = new TeeOutputStream((OutputStream)System.err, (OutputStream)err);
            int ret = 0;
            Collection<String> cmd = this.buildCommand(file, version, type, pluginPath, outputDir, outputOptions);
            ret = this.protocCommand == null ? Protoc.runProtoc(cmd.toArray(new String[0]), (OutputStream)outTee, (OutputStream)errTee) : Protoc.runProtoc(this.protocCommand, Arrays.asList(cmd.toArray(new String[0])), (OutputStream)outTee, (OutputStream)errTee);
            String errStr = err.toString();
            if (!ProtocJarMojo.isEmpty(errStr)) {
                String[] lines;
                int severity = ret != 0 ? 2 : 1;
                for (String line : lines = errStr.split("\\n", -1)) {
                    String[] parts;
                    int lineNum = 0;
                    int colNum = 0;
                    String msg = line;
                    if (line.contains(file.getName()) && (parts = line.split(":", 4)).length == 4) {
                        try {
                            lineNum = Integer.parseInt(parts[1]);
                            colNum = Integer.parseInt(parts[2]);
                            msg = parts[3];
                        }
                        catch (Exception e) {
                            this.getLog().warn((CharSequence)("Failed to parse protoc warning/error for " + file));
                        }
                    }
                    this.buildContext.addMessage(file, lineNum, colNum, msg, severity, null);
                }
            }
            if (ret != 0) {
                throw new MojoExecutionException("protoc-jar failed for " + file + ". Exit code " + ret);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute protoc-jar for " + file, (Exception)e);
        }
    }

    private Collection<String> buildCommand(File file, String version, String type, String pluginPath, File outputDir, String outputOptions) throws MojoExecutionException {
        ArrayList<String> cmd = new ArrayList<String>();
        this.populateIncludes(cmd);
        cmd.add("-I" + file.getParentFile().getAbsolutePath());
        if ("descriptor".equals(type)) {
            File outFile = new File(outputDir, file.getName());
            cmd.add("--descriptor_set_out=" + FilenameUtils.removeExtension((String)outFile.toString()) + ".desc");
            if (this.includeImports) {
                cmd.add("--include_imports");
            }
            if (outputOptions != null) {
                for (String arg : outputOptions.split("\\s+")) {
                    cmd.add(arg);
                }
            }
        } else {
            if (outputOptions != null) {
                cmd.add("--" + type + "_out=" + outputOptions + ":" + outputDir);
            } else {
                cmd.add("--" + type + "_out=" + outputDir);
            }
            if (pluginPath != null) {
                this.getLog().info((CharSequence)("    Plugin path: " + pluginPath));
                cmd.add("--plugin=protoc-gen-" + type + "=" + pluginPath);
            }
        }
        cmd.add(file.toString());
        if (version != null) {
            cmd.add("-v" + version);
        }
        return cmd;
    }

    private void populateIncludes(Collection<String> args) throws MojoExecutionException {
        for (File include : this.includeDirectories) {
            if (!include.exists()) {
                throw new MojoExecutionException("Include path '" + include.getPath() + "' does not exist");
            }
            if (!include.isDirectory()) {
                throw new MojoExecutionException("Include path '" + include.getPath() + "' is not a directory");
            }
            args.add("-I" + include.getPath());
        }
    }

    private File resolveArtifact(String artifactSpec, File dir) throws MojoExecutionException {
        try {
            Properties detectorProps = new Properties();
            new PlatformDetector().detect(detectorProps, null);
            String platform = detectorProps.getProperty("os.detected.classifier");
            this.getLog().info((CharSequence)("Resolving artifact: " + artifactSpec + ", platform: " + platform));
            String[] as = ProtocJarMojo.parseArtifactSpec(artifactSpec, platform);
            Artifact artifact = this.artifactFactory.createDependencyArtifact(as[0], as[1], VersionRange.createFromVersionSpec((String)as[2]), as[3], as[4], "runtime");
            this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            File tempFile = File.createTempFile(as[1], "." + as[3], dir);
            ProtocJarMojo.copyFile(artifact.getFile(), tempFile);
            tempFile.setExecutable(true);
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error resolving artifact: " + artifactSpec, e);
        }
    }

    static String[] parseArtifactSpec(String artifactSpec, String platform) {
        String[] as = artifactSpec.split(":");
        String[] ret = Arrays.copyOf(as, 5);
        if (ret[3] == null) {
            ret[3] = "exe";
        }
        if (ret[4] == null) {
            ret[4] = platform;
        }
        return ret;
    }

    static long minFileTime(OutputTarget[] outputTargets) {
        long minTime = Long.MAX_VALUE;
        for (OutputTarget target : outputTargets) {
            minTime = Math.min(minTime, ProtocJarMojo.minFileTime(target.outputDirectory));
        }
        return minTime;
    }

    static long maxFileTime(File[] dirs) {
        long maxTime = Long.MIN_VALUE;
        for (File dir : dirs) {
            maxTime = Math.max(maxTime, ProtocJarMojo.maxFileTime(dir));
        }
        return maxTime;
    }

    static long minFileTime(File current) {
        if (!current.isDirectory()) {
            return current.lastModified();
        }
        long minTime = Long.MAX_VALUE;
        for (File entry : current.listFiles()) {
            minTime = Math.min(minTime, ProtocJarMojo.minFileTime(entry));
        }
        return minTime;
    }

    static long maxFileTime(File current) {
        if (!current.isDirectory()) {
            return current.lastModified();
        }
        long maxTime = Long.MIN_VALUE;
        for (File entry : current.listFiles()) {
            maxTime = Math.max(maxTime, ProtocJarMojo.maxFileTime(entry));
        }
        return maxTime;
    }

    static File createTempDir(String name) throws MojoExecutionException {
        try {
            File tmpDir = File.createTempFile(name, "");
            tmpDir.delete();
            tmpDir.mkdirs();
            tmpDir.deleteOnExit();
            return tmpDir;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating temporary directory: " + name, (Exception)e);
        }
    }

    static File[] addDir(File[] dirs, File dir) {
        if (dirs == null) {
            dirs = new File[]{dir};
        } else {
            dirs = Arrays.copyOf(dirs, dirs.length + 1);
            dirs[dirs.length - 1] = dir;
        }
        return dirs;
    }

    static void deleteOnExitRecursive(File dir) {
        dir.deleteOnExit();
        for (File f : dir.listFiles()) {
            f.deleteOnExit();
            if (!f.isDirectory()) continue;
            ProtocJarMojo.deleteOnExitRecursive(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File copyFile(File srcFile, File destFile) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(srcFile);
            os = new FileOutputStream(destFile);
            ProtocJarMojo.streamCopy(is, os);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return destFile;
    }

    static void streamCopy(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) > 0) {
            out.write(buf, 0, read);
        }
    }

    static boolean isEmpty(String s) {
        return s == null || s.length() <= 0;
    }

    static class FileFilter
    implements IOFileFilter {
        String extension;

        public FileFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }

        public boolean accept(File file) {
            return file.getName().endsWith(this.extension);
        }
    }
}

