/*
 * Decompiled with CFR 0.152.
 */
package com.moczul.ok2curl;

import com.moczul.ok2curl.CommandComponent;
import com.moczul.ok2curl.Configuration;
import com.moczul.ok2curl.Header;
import com.moczul.ok2curl.LimitedSink;
import com.moczul.ok2curl.modifier.HeaderModifier;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\n*\b\u0012\u0004\u0012\u00020\u001f0\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/moczul/ok2curl/CurlCommandGenerator;", "", "configuration", "Lcom/moczul/ok2curl/Configuration;", "(Lcom/moczul/ok2curl/Configuration;)V", "generate", "", "request", "Lokhttp3/Request;", "generateBody", "", "body", "Lokhttp3/RequestBody;", "generateCommandComponent", "commandComponent", "Lcom/moczul/ok2curl/CommandComponent;", "generateFlags", "generateHeaders", "headers", "Lokhttp3/Headers;", "generateMethod", "method", "generateUrl", "url", "Lokhttp3/HttpUrl;", "getBodyAsString", "getCharset", "Ljava/nio/charset/Charset;", "mediaType", "Lokhttp3/MediaType;", "modifyHeader", "Lcom/moczul/ok2curl/Header;", "header", "applyContentTypeHeader", "Companion", "ok2curl"})
public final class CurlCommandGenerator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Configuration configuration;
    @Deprecated
    @NotNull
    public static final String FORMAT_HEADER = "-H \"%1$s:%2$s\"";
    @Deprecated
    @NotNull
    public static final String FORMAT_METHOD = "-X %1$s";
    @Deprecated
    @NotNull
    public static final String FORMAT_BODY = "-d '%1$s'";
    @Deprecated
    @NotNull
    public static final String FORMAT_URL = "\"%1$s\"";
    @Deprecated
    @NotNull
    public static final String CONTENT_TYPE = "Content-Type";

    public CurlCommandGenerator(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generate(@NotNull Request request) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Iterable $this$flatMap$iv = this.configuration.getComponents();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CommandComponent it = (CommandComponent)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.generateCommandComponent(it, request);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)this.configuration.getDelimiter(), null, null, (int)0, null, null, (int)62, null);
    }

    private final List<String> generateCommandComponent(CommandComponent commandComponent, Request request) {
        List<String> list;
        CommandComponent commandComponent2 = commandComponent;
        if (Intrinsics.areEqual((Object)commandComponent2, (Object)CommandComponent.Curl.INSTANCE)) {
            list = CollectionsKt.listOf((Object)"curl");
        } else if (Intrinsics.areEqual((Object)commandComponent2, (Object)CommandComponent.Url.INSTANCE)) {
            list = this.generateUrl(request.url());
        } else if (Intrinsics.areEqual((Object)commandComponent2, (Object)CommandComponent.Flags.INSTANCE)) {
            list = this.generateFlags();
        } else if (Intrinsics.areEqual((Object)commandComponent2, (Object)CommandComponent.Body.INSTANCE)) {
            list = this.generateBody(request.body());
        } else if (Intrinsics.areEqual((Object)commandComponent2, (Object)CommandComponent.Method.INSTANCE)) {
            list = this.generateMethod(request.method());
        } else if (Intrinsics.areEqual((Object)commandComponent2, (Object)CommandComponent.Header.INSTANCE)) {
            list = this.generateHeaders(request.headers(), request.body());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final List<String> generateBody(RequestBody body) {
        List list;
        if (body != null) {
            String bodyString = this.getBodyAsString(body);
            list = CollectionsKt.listOf((Object)bodyString);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String getBodyAsString(RequestBody body) {
        String string;
        try {
            Buffer sink = new Buffer();
            MediaType mediaType = body.contentType();
            Charset charset = this.getCharset(mediaType);
            if (this.configuration.getLimit() > 0L) {
                BufferedSink buffer = Okio.buffer((Sink)new LimitedSink(sink, this.configuration.getLimit()));
                body.writeTo(buffer);
                buffer.flush();
            } else {
                body.writeTo((BufferedSink)sink);
            }
            String string2 = FORMAT_BODY;
            Object[] objectArray = new Object[]{sink.readString(charset)};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
            string = string3;
        }
        catch (IOException e) {
            string = "Error while reading body: " + e;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> generateHeaders(Headers headers, RequestBody body) {
        Iterable $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = (Iterable)headers;
        Object object = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Header((String)it.getFirst(), (String)it.getSecond()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Header it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Header header = (Header)element$iv$iv;
            boolean bl2 = false;
            if (this.modifyHeader(header) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$map$iv = ((CurlCommandGenerator)object).applyContentTypeHeader((List)destination$iv$iv, body);
        $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void header;
            it = (Header)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = FORMAT_HEADER;
            Object[] objectArray = new Object[]{header.getName(), header.getValue()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            object.add(string2);
        }
        return (List)destination$iv$iv;
    }

    private final Header modifyHeader(Header header) {
        Object v0;
        block1: {
            Iterable iterable = this.configuration.getHeaderModifiers();
            for (Object t : iterable) {
                HeaderModifier it = (HeaderModifier)t;
                boolean bl = false;
                if (!it.matches(header)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        HeaderModifier modifier = v0;
        return modifier != null ? modifier.modify(header) : header;
    }

    private final List<String> generateMethod(String method) {
        String string = FORMAT_METHOD;
        Object[] objectArray = new Object[1];
        String string2 = method;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        Intrinsics.checkNotNullExpressionValue((Object)string2.toUpperCase(locale), (String)"this as java.lang.String).toUpperCase(locale)");
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        return CollectionsKt.listOf((Object)string3);
    }

    private final List<String> generateFlags() {
        return this.configuration.getFlags().list();
    }

    private final List<String> generateUrl(HttpUrl url) {
        String string = FORMAT_URL;
        Object[] objectArray = new Object[]{url.toString()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return CollectionsKt.listOf((Object)string2);
    }

    private final Charset getCharset(MediaType mediaType) {
        Charset charset = Charset.defaultCharset();
        Object object = mediaType;
        if (object == null || (object = object.charset(charset)) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"default");
            object = charset;
        }
        return object;
    }

    private final List<Header> applyContentTypeHeader(List<Header> $this$applyContentTypeHeader, RequestBody body) {
        Object v0;
        block1: {
            Iterable iterable = $this$applyContentTypeHeader;
            for (Object t : iterable) {
                Header it = (Header)t;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getName(), (String)CONTENT_TYPE, (boolean)false)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Header contentTypeHeader = v0;
        RequestBody requestBody = body;
        String contentType = requestBody != null && (requestBody = requestBody.contentType()) != null ? requestBody.toString() : null;
        return contentTypeHeader == null && contentType != null ? CollectionsKt.plus((Collection)$this$applyContentTypeHeader, (Iterable)CollectionsKt.listOf((Object)new Header(CONTENT_TYPE, contentType))) : $this$applyContentTypeHeader;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/moczul/ok2curl/CurlCommandGenerator$Companion;", "", "()V", "CONTENT_TYPE", "", "FORMAT_BODY", "FORMAT_HEADER", "FORMAT_METHOD", "FORMAT_URL", "ok2curl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

